/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the information of a knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBase implements SdkPojo, Serializable, ToCopyableBuilder<KnowledgeBase.Builder, KnowledgeBase> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBase::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(KnowledgeBase::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(KnowledgeBase::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(KnowledgeBase::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(KnowledgeBase::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<KnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseConfiguration")
            .getter(getter(KnowledgeBase::knowledgeBaseConfiguration))
            .setter(setter(Builder::knowledgeBaseConfiguration))
            .constructor(KnowledgeBaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build())
            .build();

    private static final SdkField<StorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField
            .<StorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storageConfiguration")
            .getter(getter(KnowledgeBase::storageConfiguration)).setter(setter(Builder::storageConfiguration))
            .constructor(StorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KnowledgeBase::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(KnowledgeBase::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(KnowledgeBase::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(KnowledgeBase::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            NAME_FIELD, KNOWLEDGE_BASE_ARN_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD,
            STORAGE_CONFIGURATION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, FAILURE_REASONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String name;

    private final String knowledgeBaseArn;

    private final String description;

    private final String roleArn;

    private final KnowledgeBaseConfiguration knowledgeBaseConfiguration;

    private final StorageConfiguration storageConfiguration;

    private final String status;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final List<String> failureReasons;

    private KnowledgeBase(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.storageConfiguration = builder.storageConfiguration;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.failureReasons = builder.failureReasons;
    }

    /**
     * Returns the value of the KnowledgeBaseId property for this object.
     * 
     * @return The value of the KnowledgeBaseId property for this object.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the KnowledgeBaseArn property for this object.
     * 
     * @return The value of the KnowledgeBaseArn property for this object.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the RoleArn property for this object.
     * 
     * @return The value of the RoleArn property for this object.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the KnowledgeBaseConfiguration property for this object.
     * 
     * @return The value of the KnowledgeBaseConfiguration property for this object.
     */
    public final KnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return knowledgeBaseConfiguration;
    }

    /**
     * Returns the value of the StorageConfiguration property for this object.
     * 
     * @return The value of the StorageConfiguration property for this object.
     */
    public final StorageConfiguration storageConfiguration() {
        return storageConfiguration;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KnowledgeBaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see KnowledgeBaseStatus
     */
    public final KnowledgeBaseStatus status() {
        return KnowledgeBaseStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KnowledgeBaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see KnowledgeBaseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the FailureReasons property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return The value of the FailureReasons property for this object.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBase)) {
            return false;
        }
        KnowledgeBase other = (KnowledgeBase) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(name(), other.name())
                && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration())
                && Objects.equals(storageConfiguration(), other.storageConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && hasFailureReasons() == other.hasFailureReasons()
                && Objects.equals(failureReasons(), other.failureReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBase").add("KnowledgeBaseId", knowledgeBaseId()).add("Name", name())
                .add("KnowledgeBaseArn", knowledgeBaseArn()).add("Description", description()).add("RoleArn", roleArn())
                .add("KnowledgeBaseConfiguration", knowledgeBaseConfiguration())
                .add("StorageConfiguration", storageConfiguration()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "knowledgeBaseConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfiguration()));
        case "storageConfiguration":
            return Optional.ofNullable(clazz.cast(storageConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBase, T> g) {
        return obj -> g.apply((KnowledgeBase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBase> {
        /**
         * Sets the value of the KnowledgeBaseId property for this object.
         *
         * @param knowledgeBaseId
         *        The new value for the KnowledgeBaseId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the KnowledgeBaseArn property for this object.
         *
         * @param knowledgeBaseArn
         *        The new value for the KnowledgeBaseArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the RoleArn property for this object.
         *
         * @param roleArn
         *        The new value for the RoleArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the KnowledgeBaseConfiguration property for this object.
         *
         * @param knowledgeBaseConfiguration
         *        The new value for the KnowledgeBaseConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration);

        /**
         * Sets the value of the KnowledgeBaseConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseConfiguration.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #knowledgeBaseConfiguration(KnowledgeBaseConfiguration)}.
         * 
         * @param knowledgeBaseConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfiguration(KnowledgeBaseConfiguration)
         */
        default Builder knowledgeBaseConfiguration(Consumer<KnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return knowledgeBaseConfiguration(KnowledgeBaseConfiguration.builder().applyMutation(knowledgeBaseConfiguration)
                    .build());
        }

        /**
         * Sets the value of the StorageConfiguration property for this object.
         *
         * @param storageConfiguration
         *        The new value for the StorageConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfiguration(StorageConfiguration storageConfiguration);

        /**
         * Sets the value of the StorageConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfiguration(StorageConfiguration)}.
         * 
         * @param storageConfiguration
         *        a consumer that will call methods on {@link StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfiguration(StorageConfiguration)
         */
        default Builder storageConfiguration(Consumer<StorageConfiguration.Builder> storageConfiguration) {
            return storageConfiguration(StorageConfiguration.builder().applyMutation(storageConfiguration).build());
        }

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see KnowledgeBaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see KnowledgeBaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStatus
         */
        Builder status(KnowledgeBaseStatus status);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the FailureReasons property for this object.
         *
         * @param failureReasons
         *        The new value for the FailureReasons property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * Sets the value of the FailureReasons property for this object.
         *
         * @param failureReasons
         *        The new value for the FailureReasons property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String name;

        private String knowledgeBaseArn;

        private String description;

        private String roleArn;

        private KnowledgeBaseConfiguration knowledgeBaseConfiguration;

        private StorageConfiguration storageConfiguration;

        private String status;

        private Instant createdAt;

        private Instant updatedAt;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBase model) {
            knowledgeBaseId(model.knowledgeBaseId);
            name(model.name);
            knowledgeBaseArn(model.knowledgeBaseArn);
            description(model.description);
            roleArn(model.roleArn);
            knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            storageConfiguration(model.storageConfiguration);
            status(model.status);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            failureReasons(model.failureReasons);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final KnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(KnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final StorageConfiguration.Builder getStorageConfiguration() {
            return storageConfiguration != null ? storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(StorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(StorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KnowledgeBaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        @Override
        public KnowledgeBase build() {
            return new KnowledgeBase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
