/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configurations to use RDS to store knowledge base data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsConfiguration.Builder, RdsConfiguration> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(RdsConfiguration::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(RdsConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(RdsConfiguration::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(RdsConfiguration::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<RdsFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<RdsFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(RdsConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(RdsFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, FIELD_MAPPING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String credentialsSecretArn;

    private final String databaseName;

    private final String tableName;

    private final RdsFieldMapping fieldMapping;

    private RdsConfiguration(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.fieldMapping = builder.fieldMapping;
    }

    /**
     * Returns the value of the ResourceArn property for this object.
     * 
     * @return The value of the ResourceArn property for this object.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * Returns the value of the CredentialsSecretArn property for this object.
     * 
     * @return The value of the CredentialsSecretArn property for this object.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * Returns the value of the DatabaseName property for this object.
     * 
     * @return The value of the DatabaseName property for this object.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * Returns the value of the TableName property for this object.
     * 
     * @return The value of the TableName property for this object.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * Returns the value of the FieldMapping property for this object.
     * 
     * @return The value of the FieldMapping property for this object.
     */
    public final RdsFieldMapping fieldMapping() {
        return fieldMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsConfiguration)) {
            return false;
        }
        RdsConfiguration other = (RdsConfiguration) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(fieldMapping(), other.fieldMapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsConfiguration").add("ResourceArn", resourceArn())
                .add("CredentialsSecretArn", credentialsSecretArn()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("FieldMapping", fieldMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsConfiguration, T> g) {
        return obj -> g.apply((RdsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsConfiguration> {
        /**
         * Sets the value of the ResourceArn property for this object.
         *
         * @param resourceArn
         *        The new value for the ResourceArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * Sets the value of the CredentialsSecretArn property for this object.
         *
         * @param credentialsSecretArn
         *        The new value for the CredentialsSecretArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * Sets the value of the DatabaseName property for this object.
         *
         * @param databaseName
         *        The new value for the DatabaseName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * Sets the value of the TableName property for this object.
         *
         * @param tableName
         *        The new value for the TableName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * Sets the value of the FieldMapping property for this object.
         *
         * @param fieldMapping
         *        The new value for the FieldMapping property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(RdsFieldMapping fieldMapping);

        /**
         * Sets the value of the FieldMapping property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RdsFieldMapping.Builder} avoiding the
         * need to create one manually via {@link RdsFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsFieldMapping.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldMapping(RdsFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link RdsFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(RdsFieldMapping)
         */
        default Builder fieldMapping(Consumer<RdsFieldMapping.Builder> fieldMapping) {
            return fieldMapping(RdsFieldMapping.builder().applyMutation(fieldMapping).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String credentialsSecretArn;

        private String databaseName;

        private String tableName;

        private RdsFieldMapping fieldMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsConfiguration model) {
            resourceArn(model.resourceArn);
            credentialsSecretArn(model.credentialsSecretArn);
            databaseName(model.databaseName);
            tableName(model.tableName);
            fieldMapping(model.fieldMapping);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final RdsFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(RdsFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(RdsFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        @Override
        public RdsConfiguration build() {
            return new RdsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
