/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures ingestion for a vector knowledge base
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorIngestionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorIngestionConfiguration.Builder, VectorIngestionConfiguration> {
    private static final SdkField<ChunkingConfiguration> CHUNKING_CONFIGURATION_FIELD = SdkField
            .<ChunkingConfiguration> builder(MarshallingType.SDK_POJO).memberName("chunkingConfiguration")
            .getter(getter(VectorIngestionConfiguration::chunkingConfiguration)).setter(setter(Builder::chunkingConfiguration))
            .constructor(ChunkingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chunkingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNKING_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ChunkingConfiguration chunkingConfiguration;

    private VectorIngestionConfiguration(BuilderImpl builder) {
        this.chunkingConfiguration = builder.chunkingConfiguration;
    }

    /**
     * Returns the value of the ChunkingConfiguration property for this object.
     * 
     * @return The value of the ChunkingConfiguration property for this object.
     */
    public final ChunkingConfiguration chunkingConfiguration() {
        return chunkingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chunkingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorIngestionConfiguration)) {
            return false;
        }
        VectorIngestionConfiguration other = (VectorIngestionConfiguration) obj;
        return Objects.equals(chunkingConfiguration(), other.chunkingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorIngestionConfiguration").add("ChunkingConfiguration", chunkingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chunkingConfiguration":
            return Optional.ofNullable(clazz.cast(chunkingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VectorIngestionConfiguration, T> g) {
        return obj -> g.apply((VectorIngestionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorIngestionConfiguration> {
        /**
         * Sets the value of the ChunkingConfiguration property for this object.
         *
         * @param chunkingConfiguration
         *        The new value for the ChunkingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkingConfiguration(ChunkingConfiguration chunkingConfiguration);

        /**
         * Sets the value of the ChunkingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChunkingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ChunkingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChunkingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #chunkingConfiguration(ChunkingConfiguration)}.
         * 
         * @param chunkingConfiguration
         *        a consumer that will call methods on {@link ChunkingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chunkingConfiguration(ChunkingConfiguration)
         */
        default Builder chunkingConfiguration(Consumer<ChunkingConfiguration.Builder> chunkingConfiguration) {
            return chunkingConfiguration(ChunkingConfiguration.builder().applyMutation(chunkingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChunkingConfiguration chunkingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorIngestionConfiguration model) {
            chunkingConfiguration(model.chunkingConfiguration);
        }

        public final ChunkingConfiguration.Builder getChunkingConfiguration() {
            return chunkingConfiguration != null ? chunkingConfiguration.toBuilder() : null;
        }

        public final void setChunkingConfiguration(ChunkingConfiguration.BuilderImpl chunkingConfiguration) {
            this.chunkingConfiguration = chunkingConfiguration != null ? chunkingConfiguration.build() : null;
        }

        @Override
        public final Builder chunkingConfiguration(ChunkingConfiguration chunkingConfiguration) {
            this.chunkingConfiguration = chunkingConfiguration;
            return this;
        }

        @Override
        public VectorIngestionConfiguration build() {
            return new VectorIngestionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
