/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the storage configuration of the knowledge base in Redis Enterprise Cloud. For more
 * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html">Create
 * a vector index in Redis Enterprise Cloud</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedisEnterpriseCloudConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedisEnterpriseCloudConfiguration.Builder, RedisEnterpriseCloudConfiguration> {
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(RedisEnterpriseCloudConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(RedisEnterpriseCloudConfiguration::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<RedisEnterpriseCloudFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<RedisEnterpriseCloudFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(RedisEnterpriseCloudConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(RedisEnterpriseCloudFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorIndexName").getter(getter(RedisEnterpriseCloudConfiguration::vectorIndexName))
            .setter(setter(Builder::vectorIndexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_SECRET_ARN_FIELD,
            ENDPOINT_FIELD, FIELD_MAPPING_FIELD, VECTOR_INDEX_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String credentialsSecretArn;

    private final String endpoint;

    private final RedisEnterpriseCloudFieldMapping fieldMapping;

    private final String vectorIndexName;

    private RedisEnterpriseCloudConfiguration(BuilderImpl builder) {
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.endpoint = builder.endpoint;
        this.fieldMapping = builder.fieldMapping;
        this.vectorIndexName = builder.vectorIndexName;
    }

    /**
     * <p>
     * The ARN of the secret that you created in Secrets Manager that is linked to your Redis Enterprise Cloud database.
     * </p>
     * 
     * @return The ARN of the secret that you created in Secrets Manager that is linked to your Redis Enterprise Cloud
     *         database.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * <p>
     * The endpoint URL of the Redis Enterprise Cloud database.
     * </p>
     * 
     * @return The endpoint URL of the Redis Enterprise Cloud database.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final RedisEnterpriseCloudFieldMapping fieldMapping() {
        return fieldMapping;
    }

    /**
     * <p>
     * The name of the vector index.
     * </p>
     * 
     * @return The name of the vector index.
     */
    public final String vectorIndexName() {
        return vectorIndexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIndexName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedisEnterpriseCloudConfiguration)) {
            return false;
        }
        RedisEnterpriseCloudConfiguration other = (RedisEnterpriseCloudConfiguration) obj;
        return Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(fieldMapping(), other.fieldMapping())
                && Objects.equals(vectorIndexName(), other.vectorIndexName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedisEnterpriseCloudConfiguration").add("CredentialsSecretArn", credentialsSecretArn())
                .add("Endpoint", endpoint()).add("FieldMapping", fieldMapping()).add("VectorIndexName", vectorIndexName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        case "vectorIndexName":
            return Optional.ofNullable(clazz.cast(vectorIndexName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedisEnterpriseCloudConfiguration, T> g) {
        return obj -> g.apply((RedisEnterpriseCloudConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedisEnterpriseCloudConfiguration> {
        /**
         * <p>
         * The ARN of the secret that you created in Secrets Manager that is linked to your Redis Enterprise Cloud
         * database.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The ARN of the secret that you created in Secrets Manager that is linked to your Redis Enterprise
         *        Cloud database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * <p>
         * The endpoint URL of the Redis Enterprise Cloud database.
         * </p>
         * 
         * @param endpoint
         *        The endpoint URL of the Redis Enterprise Cloud database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(RedisEnterpriseCloudFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedisEnterpriseCloudFieldMapping.Builder}
         * avoiding the need to create one manually via {@link RedisEnterpriseCloudFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedisEnterpriseCloudFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMapping(RedisEnterpriseCloudFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link RedisEnterpriseCloudFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(RedisEnterpriseCloudFieldMapping)
         */
        default Builder fieldMapping(Consumer<RedisEnterpriseCloudFieldMapping.Builder> fieldMapping) {
            return fieldMapping(RedisEnterpriseCloudFieldMapping.builder().applyMutation(fieldMapping).build());
        }

        /**
         * <p>
         * The name of the vector index.
         * </p>
         * 
         * @param vectorIndexName
         *        The name of the vector index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIndexName(String vectorIndexName);
    }

    static final class BuilderImpl implements Builder {
        private String credentialsSecretArn;

        private String endpoint;

        private RedisEnterpriseCloudFieldMapping fieldMapping;

        private String vectorIndexName;

        private BuilderImpl() {
        }

        private BuilderImpl(RedisEnterpriseCloudConfiguration model) {
            credentialsSecretArn(model.credentialsSecretArn);
            endpoint(model.endpoint);
            fieldMapping(model.fieldMapping);
            vectorIndexName(model.vectorIndexName);
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final RedisEnterpriseCloudFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(RedisEnterpriseCloudFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(RedisEnterpriseCloudFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getVectorIndexName() {
            return vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        @Override
        public RedisEnterpriseCloudConfiguration build() {
            return new RedisEnterpriseCloudConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
