/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePromptRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<DeletePromptRequest.Builder, DeletePromptRequest> {
    private static final SdkField<String> PROMPT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptIdentifier").getter(getter(DeletePromptRequest::promptIdentifier))
            .setter(setter(Builder::promptIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("promptIdentifier").build()).build();

    private static final SdkField<String> PROMPT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptVersion").getter(getter(DeletePromptRequest::promptVersion))
            .setter(setter(Builder::promptVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("promptVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_IDENTIFIER_FIELD,
            PROMPT_VERSION_FIELD));

    private final String promptIdentifier;

    private final String promptVersion;

    private DeletePromptRequest(BuilderImpl builder) {
        super(builder);
        this.promptIdentifier = builder.promptIdentifier;
        this.promptVersion = builder.promptVersion;
    }

    /**
     * <p>
     * The unique identifier of the prompt.
     * </p>
     * 
     * @return The unique identifier of the prompt.
     */
    public final String promptIdentifier() {
        return promptIdentifier;
    }

    /**
     * <p>
     * The version of the prompt to delete.
     * </p>
     * 
     * @return The version of the prompt to delete.
     */
    public final String promptVersion() {
        return promptVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(promptIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(promptVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePromptRequest)) {
            return false;
        }
        DeletePromptRequest other = (DeletePromptRequest) obj;
        return Objects.equals(promptIdentifier(), other.promptIdentifier())
                && Objects.equals(promptVersion(), other.promptVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePromptRequest").add("PromptIdentifier", promptIdentifier())
                .add("PromptVersion", promptVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptIdentifier":
            return Optional.ofNullable(clazz.cast(promptIdentifier()));
        case "promptVersion":
            return Optional.ofNullable(clazz.cast(promptVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePromptRequest, T> g) {
        return obj -> g.apply((DeletePromptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePromptRequest> {
        /**
         * <p>
         * The unique identifier of the prompt.
         * </p>
         * 
         * @param promptIdentifier
         *        The unique identifier of the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptIdentifier(String promptIdentifier);

        /**
         * <p>
         * The version of the prompt to delete.
         * </p>
         * 
         * @param promptVersion
         *        The version of the prompt to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptVersion(String promptVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String promptIdentifier;

        private String promptVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePromptRequest model) {
            super(model);
            promptIdentifier(model.promptIdentifier);
            promptVersion(model.promptVersion);
        }

        public final String getPromptIdentifier() {
            return promptIdentifier;
        }

        public final void setPromptIdentifier(String promptIdentifier) {
            this.promptIdentifier = promptIdentifier;
        }

        @Override
        public final Builder promptIdentifier(String promptIdentifier) {
            this.promptIdentifier = promptIdentifier;
            return this;
        }

        public final String getPromptVersion() {
            return promptVersion;
        }

        public final void setPromptVersion(String promptVersion) {
            this.promptVersion = promptVersion;
        }

        @Override
        public final Builder promptVersion(String promptVersion) {
            this.promptVersion = promptVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePromptRequest build() {
            return new DeletePromptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
