/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPromptsResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<ListPromptsResponse.Builder, ListPromptsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPromptsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PromptSummary>> PROMPT_SUMMARIES_FIELD = SdkField
            .<List<PromptSummary>> builder(MarshallingType.LIST)
            .memberName("promptSummaries")
            .getter(getter(ListPromptsResponse::promptSummaries))
            .setter(setter(Builder::promptSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PROMPT_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<PromptSummary> promptSummaries;

    private ListPromptsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.promptSummaries = builder.promptSummaries;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
     * this token when making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         use this token when making another request in the <code>nextToken</code> field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PromptSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPromptSummaries() {
        return promptSummaries != null && !(promptSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list, each member of which contains information about a prompt using Prompt management.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptSummaries} method.
     * </p>
     * 
     * @return A list, each member of which contains information about a prompt using Prompt management.
     */
    public final List<PromptSummary> promptSummaries() {
        return promptSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPromptSummaries() ? promptSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPromptsResponse)) {
            return false;
        }
        ListPromptsResponse other = (ListPromptsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPromptSummaries() == other.hasPromptSummaries()
                && Objects.equals(promptSummaries(), other.promptSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPromptsResponse").add("NextToken", nextToken())
                .add("PromptSummaries", hasPromptSummaries() ? promptSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "promptSummaries":
            return Optional.ofNullable(clazz.cast(promptSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPromptsResponse, T> g) {
        return obj -> g.apply((ListPromptsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPromptsResponse> {
        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
         * this token when making another request in the <code>nextToken</code> field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, use this token when making another request in the <code>nextToken</code> field to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list, each member of which contains information about a prompt using Prompt management.
         * </p>
         * 
         * @param promptSummaries
         *        A list, each member of which contains information about a prompt using Prompt management.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSummaries(Collection<PromptSummary> promptSummaries);

        /**
         * <p>
         * A list, each member of which contains information about a prompt using Prompt management.
         * </p>
         * 
         * @param promptSummaries
         *        A list, each member of which contains information about a prompt using Prompt management.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSummaries(PromptSummary... promptSummaries);

        /**
         * <p>
         * A list, each member of which contains information about a prompt using Prompt management.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.PromptSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #promptSummaries(List<PromptSummary>)}.
         * 
         * @param promptSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.PromptSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptSummaries(java.util.Collection<PromptSummary>)
         */
        Builder promptSummaries(Consumer<PromptSummary.Builder>... promptSummaries);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PromptSummary> promptSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPromptsResponse model) {
            super(model);
            nextToken(model.nextToken);
            promptSummaries(model.promptSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PromptSummary.Builder> getPromptSummaries() {
            List<PromptSummary.Builder> result = PromptSummariesCopier.copyToBuilder(this.promptSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptSummaries(Collection<PromptSummary.BuilderImpl> promptSummaries) {
            this.promptSummaries = PromptSummariesCopier.copyFromBuilder(promptSummaries);
        }

        @Override
        public final Builder promptSummaries(Collection<PromptSummary> promptSummaries) {
            this.promptSummaries = PromptSummariesCopier.copy(promptSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptSummaries(PromptSummary... promptSummaries) {
            promptSummaries(Arrays.asList(promptSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptSummaries(Consumer<PromptSummary.Builder>... promptSummaries) {
            promptSummaries(Stream.of(promptSummaries).map(c -> PromptSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPromptsResponse build() {
            return new ListPromptsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
