/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint information to connect to your Salesforce data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceSourceConfiguration.Builder, SalesforceSourceConfiguration> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(SalesforceSourceConfiguration::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(SalesforceSourceConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostUrl").getter(getter(SalesforceSourceConfiguration::hostUrl)).setter(setter(Builder::hostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD, HOST_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authType;

    private final String credentialsSecretArn;

    private final String hostUrl;

    private SalesforceSourceConfiguration(BuilderImpl builder) {
        this.authType = builder.authType;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.hostUrl = builder.hostUrl;
    }

    /**
     * <p>
     * The supported authentication type to authenticate and connect to your Salesforce instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link SalesforceAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The supported authentication type to authenticate and connect to your Salesforce instance.
     * @see SalesforceAuthType
     */
    public final SalesforceAuthType authType() {
        return SalesforceAuthType.fromValue(authType);
    }

    /**
     * <p>
     * The supported authentication type to authenticate and connect to your Salesforce instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link SalesforceAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The supported authentication type to authenticate and connect to your Salesforce instance.
     * @see SalesforceAuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your
     * SharePoint site/sites. For more information on the key-value pairs that must be included in your secret,
     * depending on your authentication type, see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector"
     * >Salesforce connection configuration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for
     *         your SharePoint site/sites. For more information on the key-value pairs that must be included in your
     *         secret, depending on your authentication type, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector"
     *         >Salesforce connection configuration</a>.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * <p>
     * The Salesforce host URL or instance URL.
     * </p>
     * 
     * @return The Salesforce host URL or instance URL.
     */
    public final String hostUrl() {
        return hostUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hostUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceSourceConfiguration)) {
            return false;
        }
        SalesforceSourceConfiguration other = (SalesforceSourceConfiguration) obj;
        return Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(hostUrl(), other.hostUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceSourceConfiguration").add("AuthType", authTypeAsString())
                .add("CredentialsSecretArn", credentialsSecretArn()).add("HostUrl", hostUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "hostUrl":
            return Optional.ofNullable(clazz.cast(hostUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceSourceConfiguration, T> g) {
        return obj -> g.apply((SalesforceSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceSourceConfiguration> {
        /**
         * <p>
         * The supported authentication type to authenticate and connect to your Salesforce instance.
         * </p>
         * 
         * @param authType
         *        The supported authentication type to authenticate and connect to your Salesforce instance.
         * @see SalesforceAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceAuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The supported authentication type to authenticate and connect to your Salesforce instance.
         * </p>
         * 
         * @param authType
         *        The supported authentication type to authenticate and connect to your Salesforce instance.
         * @see SalesforceAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SalesforceAuthType
         */
        Builder authType(SalesforceAuthType authType);

        /**
         * <p>
         * The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your
         * SharePoint site/sites. For more information on the key-value pairs that must be included in your secret,
         * depending on your authentication type, see <a href=
         * "https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector"
         * >Salesforce connection configuration</a>.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for
         *        your SharePoint site/sites. For more information on the key-value pairs that must be included in your
         *        secret, depending on your authentication type, see <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector"
         *        >Salesforce connection configuration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * <p>
         * The Salesforce host URL or instance URL.
         * </p>
         * 
         * @param hostUrl
         *        The Salesforce host URL or instance URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostUrl(String hostUrl);
    }

    static final class BuilderImpl implements Builder {
        private String authType;

        private String credentialsSecretArn;

        private String hostUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceSourceConfiguration model) {
            authType(model.authType);
            credentialsSecretArn(model.credentialsSecretArn);
            hostUrl(model.hostUrl);
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(SalesforceAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getHostUrl() {
            return hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        @Override
        public SalesforceSourceConfiguration build() {
            return new SalesforceSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
