/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the routing configuration of the alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentAliasRoutingConfigurationListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentAliasRoutingConfigurationListItem.Builder, AgentAliasRoutingConfigurationListItem> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentAliasRoutingConfigurationListItem::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> PROVISIONED_THROUGHPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisionedThroughput").getter(getter(AgentAliasRoutingConfigurationListItem::provisionedThroughput))
            .setter(setter(Builder::provisionedThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedThroughput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD,
            PROVISIONED_THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentVersion;

    private final String provisionedThroughput;

    private AgentAliasRoutingConfigurationListItem(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    /**
     * <p>
     * The version of the agent with which the alias is associated.
     * </p>
     * 
     * @return The version of the agent with which the alias is associated.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * Information on the Provisioned Throughput assigned to an agent alias.
     * </p>
     * 
     * @return Information on the Provisioned Throughput assigned to an agent alias.
     */
    public final String provisionedThroughput() {
        return provisionedThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentAliasRoutingConfigurationListItem)) {
            return false;
        }
        AgentAliasRoutingConfigurationListItem other = (AgentAliasRoutingConfigurationListItem) obj;
        return Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentAliasRoutingConfigurationListItem").add("AgentVersion", agentVersion())
                .add("ProvisionedThroughput", provisionedThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "provisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentAliasRoutingConfigurationListItem, T> g) {
        return obj -> g.apply((AgentAliasRoutingConfigurationListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentAliasRoutingConfigurationListItem> {
        /**
         * <p>
         * The version of the agent with which the alias is associated.
         * </p>
         * 
         * @param agentVersion
         *        The version of the agent with which the alias is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * Information on the Provisioned Throughput assigned to an agent alias.
         * </p>
         * 
         * @param provisionedThroughput
         *        Information on the Provisioned Throughput assigned to an agent alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(String provisionedThroughput);
    }

    static final class BuilderImpl implements Builder {
        private String agentVersion;

        private String provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentAliasRoutingConfigurationListItem model) {
            agentVersion(model.agentVersion);
            provisionedThroughput(model.provisionedThroughput);
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getProvisionedThroughput() {
            return provisionedThroughput;
        }

        public final void setProvisionedThroughput(String provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(String provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        @Override
        public AgentAliasRoutingConfigurationListItem build() {
            return new AgentAliasRoutingConfigurationListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
