/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowAliasRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateFlowAliasRequest.Builder, UpdateFlowAliasRequest> {
    private static final SdkField<String> ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aliasIdentifier").getter(getter(UpdateFlowAliasRequest::aliasIdentifier))
            .setter(setter(Builder::aliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aliasIdentifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateFlowAliasRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(UpdateFlowAliasRequest::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateFlowAliasRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField
            .<List<FlowAliasRoutingConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("routingConfiguration")
            .getter(getter(UpdateFlowAliasRequest::routingConfiguration))
            .setter(setter(Builder::routingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowAliasRoutingConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowAliasRoutingConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, FLOW_IDENTIFIER_FIELD, NAME_FIELD, ROUTING_CONFIGURATION_FIELD));

    private final String aliasIdentifier;

    private final String description;

    private final String flowIdentifier;

    private final String name;

    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;

    private UpdateFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasIdentifier = builder.aliasIdentifier;
        this.description = builder.description;
        this.flowIdentifier = builder.flowIdentifier;
        this.name = builder.name;
        this.routingConfiguration = builder.routingConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the alias.
     * </p>
     * 
     * @return The unique identifier of the alias.
     */
    public final String aliasIdentifier() {
        return aliasIdentifier;
    }

    /**
     * <p>
     * A description for the flow alias.
     * </p>
     * 
     * @return A description for the flow alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * <p>
     * The name of the flow alias.
     * </p>
     * 
     * @return The name of the flow alias.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingConfiguration() {
        return routingConfiguration != null && !(routingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the version to which to map the alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingConfiguration} method.
     * </p>
     * 
     * @return Contains information about the version to which to map the alias.
     */
    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return routingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingConfiguration() ? routingConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowAliasRequest)) {
            return false;
        }
        UpdateFlowAliasRequest other = (UpdateFlowAliasRequest) obj;
        return Objects.equals(aliasIdentifier(), other.aliasIdentifier()) && Objects.equals(description(), other.description())
                && Objects.equals(flowIdentifier(), other.flowIdentifier()) && Objects.equals(name(), other.name())
                && hasRoutingConfiguration() == other.hasRoutingConfiguration()
                && Objects.equals(routingConfiguration(), other.routingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowAliasRequest").add("AliasIdentifier", aliasIdentifier())
                .add("Description", description()).add("FlowIdentifier", flowIdentifier()).add("Name", name())
                .add("RoutingConfiguration", hasRoutingConfiguration() ? routingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aliasIdentifier":
            return Optional.ofNullable(clazz.cast(aliasIdentifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "routingConfiguration":
            return Optional.ofNullable(clazz.cast(routingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowAliasRequest, T> g) {
        return obj -> g.apply((UpdateFlowAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowAliasRequest> {
        /**
         * <p>
         * The unique identifier of the alias.
         * </p>
         * 
         * @param aliasIdentifier
         *        The unique identifier of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasIdentifier(String aliasIdentifier);

        /**
         * <p>
         * A description for the flow alias.
         * </p>
         * 
         * @param description
         *        A description for the flow alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * The name of the flow alias.
         * </p>
         * 
         * @param name
         *        The name of the flow alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains information about the version to which to map the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        Contains information about the version to which to map the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration);

        /**
         * <p>
         * Contains information about the version to which to map the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        Contains information about the version to which to map the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(FlowAliasRoutingConfigurationListItem... routingConfiguration);

        /**
         * <p>
         * Contains information about the version to which to map the alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routingConfiguration(List<FlowAliasRoutingConfigurationListItem>)}.
         * 
         * @param routingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfiguration(java.util.Collection<FlowAliasRoutingConfigurationListItem>)
         */
        Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder>... routingConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String aliasIdentifier;

        private String description;

        private String flowIdentifier;

        private String name;

        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowAliasRequest model) {
            super(model);
            aliasIdentifier(model.aliasIdentifier);
            description(model.description);
            flowIdentifier(model.flowIdentifier);
            name(model.name);
            routingConfiguration(model.routingConfiguration);
        }

        public final String getAliasIdentifier() {
            return aliasIdentifier;
        }

        public final void setAliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
        }

        @Override
        public final Builder aliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier
                    .copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(
                Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem... routingConfiguration) {
            routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder>... routingConfiguration) {
            routingConfiguration(Stream.of(routingConfiguration)
                    .map(c -> FlowAliasRoutingConfigurationListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowAliasRequest build() {
            return new UpdateFlowAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
