/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFlowAliasResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<DeleteFlowAliasResponse.Builder, DeleteFlowAliasResponse> {
    private static final SdkField<String> FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("flowId")
            .getter(getter(DeleteFlowAliasResponse::flowId)).setter(setter(Builder::flowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeleteFlowAliasResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ID_FIELD, ID_FIELD));

    private final String flowId;

    private final String id;

    private DeleteFlowAliasResponse(BuilderImpl builder) {
        super(builder);
        this.flowId = builder.flowId;
        this.id = builder.id;
    }

    /**
     * <p>
     * The unique identifier of the flow that the alias belongs to.
     * </p>
     * 
     * @return The unique identifier of the flow that the alias belongs to.
     */
    public final String flowId() {
        return flowId;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowAliasResponse)) {
            return false;
        }
        DeleteFlowAliasResponse other = (DeleteFlowAliasResponse) obj;
        return Objects.equals(flowId(), other.flowId()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFlowAliasResponse").add("FlowId", flowId()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowId":
            return Optional.ofNullable(clazz.cast(flowId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFlowAliasResponse, T> g) {
        return obj -> g.apply((DeleteFlowAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFlowAliasResponse> {
        /**
         * <p>
         * The unique identifier of the flow that the alias belongs to.
         * </p>
         * 
         * @param flowId
         *        The unique identifier of the flow that the alias belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowId(String flowId);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param id
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private String flowId;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowAliasResponse model) {
            super(model);
            flowId(model.flowId);
            id(model.id);
        }

        public final String getFlowId() {
            return flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public DeleteFlowAliasResponse build() {
            return new DeleteFlowAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
