/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The vector configuration details for the Bedrock embeddings model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockEmbeddingModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockEmbeddingModelConfiguration.Builder, BedrockEmbeddingModelConfiguration> {
    private static final SdkField<Integer> DIMENSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dimensions").getter(getter(BedrockEmbeddingModelConfiguration::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dimensions;

    private BedrockEmbeddingModelConfiguration(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
    }

    /**
     * <p>
     * The dimensions details for the vector configuration used on the Bedrock embeddings model.
     * </p>
     * 
     * @return The dimensions details for the vector configuration used on the Bedrock embeddings model.
     */
    public final Integer dimensions() {
        return dimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockEmbeddingModelConfiguration)) {
            return false;
        }
        BedrockEmbeddingModelConfiguration other = (BedrockEmbeddingModelConfiguration) obj;
        return Objects.equals(dimensions(), other.dimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockEmbeddingModelConfiguration").add("Dimensions", dimensions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BedrockEmbeddingModelConfiguration, T> g) {
        return obj -> g.apply((BedrockEmbeddingModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
        /**
         * <p>
         * The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * </p>
         * 
         * @param dimensions
         *        The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Integer dimensions);
    }

    static final class BuilderImpl implements Builder {
        private Integer dimensions;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockEmbeddingModelConfiguration model) {
            dimensions(model.dimensions);
        }

        public final Integer getDimensions() {
            return dimensions;
        }

        public final void setDimensions(Integer dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public final Builder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        @Override
        public BedrockEmbeddingModelConfiguration build() {
            return new BedrockEmbeddingModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
