/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an alias of a flow.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowAliases.html#API_agent_ListFlowAliases_ResponseSyntax"
 * >ListFlowAliases response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowAliasSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowAliasSummary.Builder, FlowAliasSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(FlowAliasSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(FlowAliasSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(FlowAliasSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("flowId")
            .getter(getter(FlowAliasSummary::flowId)).setter(setter(Builder::flowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FlowAliasSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FlowAliasSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField
            .<List<FlowAliasRoutingConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("routingConfiguration")
            .getter(getter(FlowAliasSummary::routingConfiguration))
            .setter(setter(Builder::routingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowAliasRoutingConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowAliasRoutingConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(FlowAliasSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESCRIPTION_FIELD, FLOW_ID_FIELD, ID_FIELD, NAME_FIELD, ROUTING_CONFIGURATION_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String description;

    private final String flowId;

    private final String id;

    private final String name;

    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;

    private final Instant updatedAt;

    private FlowAliasSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.flowId = builder.flowId;
        this.id = builder.id;
        this.name = builder.name;
        this.routingConfiguration = builder.routingConfiguration;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alias.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the alias was created.
     * </p>
     * 
     * @return The time at which the alias was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description of the alias.
     * </p>
     * 
     * @return A description of the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowId() {
        return flowId;
    }

    /**
     * <p>
     * The unique identifier of the alias of the flow.
     * </p>
     * 
     * @return The unique identifier of the alias of the flow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the alias.
     * </p>
     * 
     * @return The name of the alias.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingConfiguration() {
        return routingConfiguration != null && !(routingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configurations about the versions that the alias maps to. Currently, you can only specify one.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingConfiguration} method.
     * </p>
     * 
     * @return A list of configurations about the versions that the alias maps to. Currently, you can only specify one.
     */
    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return routingConfiguration;
    }

    /**
     * <p>
     * The time at which the alias was last updated.
     * </p>
     * 
     * @return The time at which the alias was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingConfiguration() ? routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowAliasSummary)) {
            return false;
        }
        FlowAliasSummary other = (FlowAliasSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(flowId(), other.flowId())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && hasRoutingConfiguration() == other.hasRoutingConfiguration()
                && Objects.equals(routingConfiguration(), other.routingConfiguration())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowAliasSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Description", description()).add("FlowId", flowId()).add("Id", id()).add("Name", name())
                .add("RoutingConfiguration", hasRoutingConfiguration() ? routingConfiguration() : null)
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "flowId":
            return Optional.ofNullable(clazz.cast(flowId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "routingConfiguration":
            return Optional.ofNullable(clazz.cast(routingConfiguration()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowAliasSummary, T> g) {
        return obj -> g.apply((FlowAliasSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowAliasSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alias.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the alias was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description of the alias.
         * </p>
         * 
         * @param description
         *        A description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowId
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowId(String flowId);

        /**
         * <p>
         * The unique identifier of the alias of the flow.
         * </p>
         * 
         * @param id
         *        The unique identifier of the alias of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the alias.
         * </p>
         * 
         * @param name
         *        The name of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of configurations about the versions that the alias maps to. Currently, you can only specify one.
         * </p>
         * 
         * @param routingConfiguration
         *        A list of configurations about the versions that the alias maps to. Currently, you can only specify
         *        one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration);

        /**
         * <p>
         * A list of configurations about the versions that the alias maps to. Currently, you can only specify one.
         * </p>
         * 
         * @param routingConfiguration
         *        A list of configurations about the versions that the alias maps to. Currently, you can only specify
         *        one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(FlowAliasRoutingConfigurationListItem... routingConfiguration);

        /**
         * <p>
         * A list of configurations about the versions that the alias maps to. Currently, you can only specify one.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routingConfiguration(List<FlowAliasRoutingConfigurationListItem>)}.
         * 
         * @param routingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfiguration(java.util.Collection<FlowAliasRoutingConfigurationListItem>)
         */
        Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder>... routingConfiguration);

        /**
         * <p>
         * The time at which the alias was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the alias was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String description;

        private String flowId;

        private String id;

        private String name;

        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowAliasSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            description(model.description);
            flowId(model.flowId);
            id(model.id);
            name(model.name);
            routingConfiguration(model.routingConfiguration);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowId() {
            return flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier
                    .copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(
                Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem... routingConfiguration) {
            routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder>... routingConfiguration) {
            routingConfiguration(Stream.of(routingConfiguration)
                    .map(c -> FlowAliasRoutingConfigurationListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public FlowAliasSummary build() {
            return new FlowAliasSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
