/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a connection between a condition node and another node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowConditionalConnectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowConditionalConnectionConfiguration.Builder, FlowConditionalConnectionConfiguration> {
    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("condition").getter(getter(FlowConditionalConnectionConfiguration::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String condition;

    private FlowConditionalConnectionConfiguration(BuilderImpl builder) {
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The condition that triggers this connection. For more information about how to write conditions, see the
     * <b>Condition</b> node type in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the Amazon
     * Bedrock User Guide.
     * </p>
     * 
     * @return The condition that triggers this connection. For more information about how to write conditions, see the
     *         <b>Condition</b> node type in the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the
     *         Amazon Bedrock User Guide.
     */
    public final String condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowConditionalConnectionConfiguration)) {
            return false;
        }
        FlowConditionalConnectionConfiguration other = (FlowConditionalConnectionConfiguration) obj;
        return Objects.equals(condition(), other.condition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowConditionalConnectionConfiguration").add("Condition", condition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowConditionalConnectionConfiguration, T> g) {
        return obj -> g.apply((FlowConditionalConnectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowConditionalConnectionConfiguration> {
        /**
         * <p>
         * The condition that triggers this connection. For more information about how to write conditions, see the
         * <b>Condition</b> node type in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the
         * Amazon Bedrock User Guide.
         * </p>
         * 
         * @param condition
         *        The condition that triggers this connection. For more information about how to write conditions, see
         *        the <b>Condition</b> node type in the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in
         *        the Amazon Bedrock User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);
    }

    static final class BuilderImpl implements Builder {
        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowConditionalConnectionConfiguration model) {
            condition(model.condition);
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public FlowConditionalConnectionConfiguration build() {
            return new FlowConditionalConnectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
