/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for the embeddings model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmbeddingModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EmbeddingModelConfiguration.Builder, EmbeddingModelConfiguration> {
    private static final SdkField<BedrockEmbeddingModelConfiguration> BEDROCK_EMBEDDING_MODEL_CONFIGURATION_FIELD = SdkField
            .<BedrockEmbeddingModelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockEmbeddingModelConfiguration")
            .getter(getter(EmbeddingModelConfiguration::bedrockEmbeddingModelConfiguration))
            .setter(setter(Builder::bedrockEmbeddingModelConfiguration))
            .constructor(BedrockEmbeddingModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockEmbeddingModelConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BEDROCK_EMBEDDING_MODEL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final BedrockEmbeddingModelConfiguration bedrockEmbeddingModelConfiguration;

    private EmbeddingModelConfiguration(BuilderImpl builder) {
        this.bedrockEmbeddingModelConfiguration = builder.bedrockEmbeddingModelConfiguration;
    }

    /**
     * <p>
     * The vector configuration details on the Bedrock embeddings model.
     * </p>
     * 
     * @return The vector configuration details on the Bedrock embeddings model.
     */
    public final BedrockEmbeddingModelConfiguration bedrockEmbeddingModelConfiguration() {
        return bedrockEmbeddingModelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockEmbeddingModelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddingModelConfiguration)) {
            return false;
        }
        EmbeddingModelConfiguration other = (EmbeddingModelConfiguration) obj;
        return Objects.equals(bedrockEmbeddingModelConfiguration(), other.bedrockEmbeddingModelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmbeddingModelConfiguration")
                .add("BedrockEmbeddingModelConfiguration", bedrockEmbeddingModelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockEmbeddingModelConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockEmbeddingModelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmbeddingModelConfiguration, T> g) {
        return obj -> g.apply((EmbeddingModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmbeddingModelConfiguration> {
        /**
         * <p>
         * The vector configuration details on the Bedrock embeddings model.
         * </p>
         * 
         * @param bedrockEmbeddingModelConfiguration
         *        The vector configuration details on the Bedrock embeddings model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfiguration bedrockEmbeddingModelConfiguration);

        /**
         * <p>
         * The vector configuration details on the Bedrock embeddings model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockEmbeddingModelConfiguration.Builder} avoiding the need to create one manually via
         * {@link BedrockEmbeddingModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockEmbeddingModelConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfiguration)}.
         * 
         * @param bedrockEmbeddingModelConfiguration
         *        a consumer that will call methods on {@link BedrockEmbeddingModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfiguration)
         */
        default Builder bedrockEmbeddingModelConfiguration(
                Consumer<BedrockEmbeddingModelConfiguration.Builder> bedrockEmbeddingModelConfiguration) {
            return bedrockEmbeddingModelConfiguration(BedrockEmbeddingModelConfiguration.builder()
                    .applyMutation(bedrockEmbeddingModelConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BedrockEmbeddingModelConfiguration bedrockEmbeddingModelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddingModelConfiguration model) {
            bedrockEmbeddingModelConfiguration(model.bedrockEmbeddingModelConfiguration);
        }

        public final BedrockEmbeddingModelConfiguration.Builder getBedrockEmbeddingModelConfiguration() {
            return bedrockEmbeddingModelConfiguration != null ? bedrockEmbeddingModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockEmbeddingModelConfiguration(
                BedrockEmbeddingModelConfiguration.BuilderImpl bedrockEmbeddingModelConfiguration) {
            this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration != null ? bedrockEmbeddingModelConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bedrockEmbeddingModelConfiguration(
                BedrockEmbeddingModelConfiguration bedrockEmbeddingModelConfiguration) {
            this.bedrockEmbeddingModelConfiguration = bedrockEmbeddingModelConfiguration;
            return this;
        }

        @Override
        public EmbeddingModelConfiguration build() {
            return new EmbeddingModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
