/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKnowledgeBaseResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<GetKnowledgeBaseResponse.Builder, GetKnowledgeBaseResponse> {
    private static final SdkField<KnowledgeBase> KNOWLEDGE_BASE_FIELD = SdkField
            .<KnowledgeBase> builder(MarshallingType.SDK_POJO).memberName("knowledgeBase")
            .getter(getter(GetKnowledgeBaseResponse::knowledgeBase)).setter(setter(Builder::knowledgeBase))
            .constructor(KnowledgeBase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_FIELD));

    private final KnowledgeBase knowledgeBase;

    private GetKnowledgeBaseResponse(BuilderImpl builder) {
        super(builder);
        this.knowledgeBase = builder.knowledgeBase;
    }

    /**
     * <p>
     * Contains details about the knowledge base.
     * </p>
     * 
     * @return Contains details about the knowledge base.
     */
    public final KnowledgeBase knowledgeBase() {
        return knowledgeBase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKnowledgeBaseResponse)) {
            return false;
        }
        GetKnowledgeBaseResponse other = (GetKnowledgeBaseResponse) obj;
        return Objects.equals(knowledgeBase(), other.knowledgeBase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKnowledgeBaseResponse").add("KnowledgeBase", knowledgeBase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBase":
            return Optional.ofNullable(clazz.cast(knowledgeBase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKnowledgeBaseResponse, T> g) {
        return obj -> g.apply((GetKnowledgeBaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKnowledgeBaseResponse> {
        /**
         * <p>
         * Contains details about the knowledge base.
         * </p>
         * 
         * @param knowledgeBase
         *        Contains details about the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBase(KnowledgeBase knowledgeBase);

        /**
         * <p>
         * Contains details about the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBase.Builder} avoiding the need
         * to create one manually via {@link KnowledgeBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBase.Builder#build()} is called immediately and its
         * result is passed to {@link #knowledgeBase(KnowledgeBase)}.
         * 
         * @param knowledgeBase
         *        a consumer that will call methods on {@link KnowledgeBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBase(KnowledgeBase)
         */
        default Builder knowledgeBase(Consumer<KnowledgeBase.Builder> knowledgeBase) {
            return knowledgeBase(KnowledgeBase.builder().applyMutation(knowledgeBase).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private KnowledgeBase knowledgeBase;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKnowledgeBaseResponse model) {
            super(model);
            knowledgeBase(model.knowledgeBase);
        }

        public final KnowledgeBase.Builder getKnowledgeBase() {
            return knowledgeBase != null ? knowledgeBase.toBuilder() : null;
        }

        public final void setKnowledgeBase(KnowledgeBase.BuilderImpl knowledgeBase) {
            this.knowledgeBase = knowledgeBase != null ? knowledgeBase.build() : null;
        }

        @Override
        public final Builder knowledgeBase(KnowledgeBase knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        @Override
        public GetKnowledgeBaseResponse build() {
            return new GetKnowledgeBaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
