/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a prompt defined inline in the node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptFlowNodeInlineConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptFlowNodeInlineConfiguration.Builder, PromptFlowNodeInlineConfiguration> {
    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<PromptInferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(PromptFlowNodeInlineConfiguration::inferenceConfiguration))
            .setter(setter(Builder::inferenceConfiguration)).constructor(PromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(PromptFlowNodeInlineConfiguration::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<PromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<PromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("templateConfiguration")
            .getter(getter(PromptFlowNodeInlineConfiguration::templateConfiguration))
            .setter(setter(Builder::templateConfiguration)).constructor(PromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build())
            .build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(PromptFlowNodeInlineConfiguration::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_CONFIGURATION_FIELD,
            MODEL_ID_FIELD, TEMPLATE_CONFIGURATION_FIELD, TEMPLATE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PromptInferenceConfiguration inferenceConfiguration;

    private final String modelId;

    private final PromptTemplateConfiguration templateConfiguration;

    private final String templateType;

    private PromptFlowNodeInlineConfiguration(BuilderImpl builder) {
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.modelId = builder.modelId;
        this.templateConfiguration = builder.templateConfiguration;
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * Contains inference configurations for the prompt.
     * </p>
     * 
     * @return Contains inference configurations for the prompt.
     */
    public final PromptInferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to
     * run inference with.
     * </p>
     * 
     * @return The unique identifier of the model or <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
     *         profile</a> to run inference with.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Contains a prompt and variables in the prompt that can be replaced with values at runtime.
     * </p>
     * 
     * @return Contains a prompt and variables in the prompt that can be replaced with values at runtime.
     */
    public final PromptTemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The type of prompt template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link PromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of prompt template.
     * @see PromptTemplateType
     */
    public final PromptTemplateType templateType() {
        return PromptTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of prompt template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link PromptTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of prompt template.
     * @see PromptTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptFlowNodeInlineConfiguration)) {
            return false;
        }
        PromptFlowNodeInlineConfiguration other = (PromptFlowNodeInlineConfiguration) obj;
        return Objects.equals(inferenceConfiguration(), other.inferenceConfiguration())
                && Objects.equals(modelId(), other.modelId())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptFlowNodeInlineConfiguration").add("InferenceConfiguration", inferenceConfiguration())
                .add("ModelId", modelId()).add("TemplateConfiguration", templateConfiguration())
                .add("TemplateType", templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "templateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptFlowNodeInlineConfiguration, T> g) {
        return obj -> g.apply((PromptFlowNodeInlineConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptFlowNodeInlineConfiguration> {
        /**
         * <p>
         * Contains inference configurations for the prompt.
         * </p>
         * 
         * @param inferenceConfiguration
         *        Contains inference configurations for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration);

        /**
         * <p>
         * Contains inference configurations for the prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptInferenceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceConfiguration(PromptInferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link PromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(PromptInferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<PromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(PromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        /**
         * <p>
         * The unique identifier of the model or <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>
         * to run inference with.
         * </p>
         * 
         * @param modelId
         *        The unique identifier of the model or <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
         *        profile</a> to run inference with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Contains a prompt and variables in the prompt that can be replaced with values at runtime.
         * </p>
         * 
         * @param templateConfiguration
         *        Contains a prompt and variables in the prompt that can be replaced with values at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(PromptTemplateConfiguration templateConfiguration);

        /**
         * <p>
         * Contains a prompt and variables in the prompt that can be replaced with values at runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #templateConfiguration(PromptTemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link PromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(PromptTemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<PromptTemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(PromptTemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The type of prompt template.
         * </p>
         * 
         * @param templateType
         *        The type of prompt template.
         * @see PromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of prompt template.
         * </p>
         * 
         * @param templateType
         *        The type of prompt template.
         * @see PromptTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptTemplateType
         */
        Builder templateType(PromptTemplateType templateType);
    }

    static final class BuilderImpl implements Builder {
        private PromptInferenceConfiguration inferenceConfiguration;

        private String modelId;

        private PromptTemplateConfiguration templateConfiguration;

        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptFlowNodeInlineConfiguration model) {
            inferenceConfiguration(model.inferenceConfiguration);
            modelId(model.modelId);
            templateConfiguration(model.templateConfiguration);
            templateType(model.templateType);
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(PromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final PromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(PromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(PromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(PromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public PromptFlowNodeInlineConfiguration build() {
            return new PromptFlowNodeInlineConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
