/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a Storage node in a flow. This node stores the input in an Amazon S3 location that you
 * specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageFlowNodeConfiguration.Builder, StorageFlowNodeConfiguration> {
    private static final SdkField<StorageFlowNodeServiceConfiguration> SERVICE_CONFIGURATION_FIELD = SdkField
            .<StorageFlowNodeServiceConfiguration> builder(MarshallingType.SDK_POJO).memberName("serviceConfiguration")
            .getter(getter(StorageFlowNodeConfiguration::serviceConfiguration)).setter(setter(Builder::serviceConfiguration))
            .constructor(StorageFlowNodeServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final StorageFlowNodeServiceConfiguration serviceConfiguration;

    private StorageFlowNodeConfiguration(BuilderImpl builder) {
        this.serviceConfiguration = builder.serviceConfiguration;
    }

    /**
     * <p>
     * Contains configurations for the service to use for storing the input into the node.
     * </p>
     * 
     * @return Contains configurations for the service to use for storing the input into the node.
     */
    public final StorageFlowNodeServiceConfiguration serviceConfiguration() {
        return serviceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageFlowNodeConfiguration)) {
            return false;
        }
        StorageFlowNodeConfiguration other = (StorageFlowNodeConfiguration) obj;
        return Objects.equals(serviceConfiguration(), other.serviceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageFlowNodeConfiguration").add("ServiceConfiguration", serviceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceConfiguration":
            return Optional.ofNullable(clazz.cast(serviceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageFlowNodeConfiguration, T> g) {
        return obj -> g.apply((StorageFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageFlowNodeConfiguration> {
        /**
         * <p>
         * Contains configurations for the service to use for storing the input into the node.
         * </p>
         * 
         * @param serviceConfiguration
         *        Contains configurations for the service to use for storing the input into the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConfiguration(StorageFlowNodeServiceConfiguration serviceConfiguration);

        /**
         * <p>
         * Contains configurations for the service to use for storing the input into the node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StorageFlowNodeServiceConfiguration.Builder} avoiding the need to create one manually via
         * {@link StorageFlowNodeServiceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageFlowNodeServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceConfiguration(StorageFlowNodeServiceConfiguration)}.
         * 
         * @param serviceConfiguration
         *        a consumer that will call methods on {@link StorageFlowNodeServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConfiguration(StorageFlowNodeServiceConfiguration)
         */
        default Builder serviceConfiguration(Consumer<StorageFlowNodeServiceConfiguration.Builder> serviceConfiguration) {
            return serviceConfiguration(StorageFlowNodeServiceConfiguration.builder().applyMutation(serviceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StorageFlowNodeServiceConfiguration serviceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageFlowNodeConfiguration model) {
            serviceConfiguration(model.serviceConfiguration);
        }

        public final StorageFlowNodeServiceConfiguration.Builder getServiceConfiguration() {
            return serviceConfiguration != null ? serviceConfiguration.toBuilder() : null;
        }

        public final void setServiceConfiguration(StorageFlowNodeServiceConfiguration.BuilderImpl serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration != null ? serviceConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConfiguration(StorageFlowNodeServiceConfiguration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        @Override
        public StorageFlowNodeConfiguration build() {
            return new StorageFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
