/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIngestionJobResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<GetIngestionJobResponse.Builder, GetIngestionJobResponse> {
    private static final SdkField<IngestionJob> INGESTION_JOB_FIELD = SdkField.<IngestionJob> builder(MarshallingType.SDK_POJO)
            .memberName("ingestionJob").getter(getter(GetIngestionJobResponse::ingestionJob))
            .setter(setter(Builder::ingestionJob)).constructor(IngestionJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_JOB_FIELD));

    private final IngestionJob ingestionJob;

    private GetIngestionJobResponse(BuilderImpl builder) {
        super(builder);
        this.ingestionJob = builder.ingestionJob;
    }

    /**
     * <p>
     * Contains details about the data ingestion job.
     * </p>
     * 
     * @return Contains details about the data ingestion job.
     */
    public final IngestionJob ingestionJob() {
        return ingestionJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingestionJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIngestionJobResponse)) {
            return false;
        }
        GetIngestionJobResponse other = (GetIngestionJobResponse) obj;
        return Objects.equals(ingestionJob(), other.ingestionJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIngestionJobResponse").add("IngestionJob", ingestionJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingestionJob":
            return Optional.ofNullable(clazz.cast(ingestionJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIngestionJobResponse, T> g) {
        return obj -> g.apply((GetIngestionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIngestionJobResponse> {
        /**
         * <p>
         * Contains details about the data ingestion job.
         * </p>
         * 
         * @param ingestionJob
         *        Contains details about the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionJob(IngestionJob ingestionJob);

        /**
         * <p>
         * Contains details about the data ingestion job.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestionJob.Builder} avoiding the need
         * to create one manually via {@link IngestionJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionJob.Builder#build()} is called immediately and its
         * result is passed to {@link #ingestionJob(IngestionJob)}.
         * 
         * @param ingestionJob
         *        a consumer that will call methods on {@link IngestionJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionJob(IngestionJob)
         */
        default Builder ingestionJob(Consumer<IngestionJob.Builder> ingestionJob) {
            return ingestionJob(IngestionJob.builder().applyMutation(ingestionJob).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private IngestionJob ingestionJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIngestionJobResponse model) {
            super(model);
            ingestionJob(model.ingestionJob);
        }

        public final IngestionJob.Builder getIngestionJob() {
            return ingestionJob != null ? ingestionJob.toBuilder() : null;
        }

        public final void setIngestionJob(IngestionJob.BuilderImpl ingestionJob) {
            this.ingestionJob = ingestionJob != null ? ingestionJob.build() : null;
        }

        @Override
        public final Builder ingestionJob(IngestionJob ingestionJob) {
            this.ingestionJob = ingestionJob;
            return this;
        }

        @Override
        public GetIngestionJobResponse build() {
            return new GetIngestionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
