/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a knowledge base node in a flow. This node takes a query as the input and returns, as the
 * output, the retrieved responses directly (as an array) or a response generated based on the retrieved responses. For
 * more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in
 * Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseFlowNodeConfiguration.Builder, KnowledgeBaseFlowNodeConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseFlowNodeConfiguration::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(KnowledgeBaseFlowNodeConfiguration::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            MODEL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String modelId;

    private KnowledgeBaseFlowNodeConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelId = builder.modelId;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base to query.
     * </p>
     * 
     * @return The unique identifier of the knowledge base to query.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The unique identifier of the model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to
     * use to generate a response from the query results. Omit this field if you want to return the retrieved results as
     * an array.
     * </p>
     * 
     * @return The unique identifier of the model or <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
     *         profile</a> to use to generate a response from the query results. Omit this field if you want to return
     *         the retrieved results as an array.
     */
    public final String modelId() {
        return modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseFlowNodeConfiguration)) {
            return false;
        }
        KnowledgeBaseFlowNodeConfiguration other = (KnowledgeBaseFlowNodeConfiguration) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(modelId(), other.modelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseFlowNodeConfiguration").add("KnowledgeBaseId", knowledgeBaseId())
                .add("ModelId", modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseFlowNodeConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
        /**
         * <p>
         * The unique identifier of the knowledge base to query.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base to query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The unique identifier of the model or <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>
         * to use to generate a response from the query results. Omit this field if you want to return the retrieved
         * results as an array.
         * </p>
         * 
         * @param modelId
         *        The unique identifier of the model or <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference
         *        profile</a> to use to generate a response from the query results. Omit this field if you want to
         *        return the retrieved results as an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseFlowNodeConfiguration model) {
            knowledgeBaseId(model.knowledgeBaseId);
            modelId(model.modelId);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public KnowledgeBaseFlowNodeConfiguration build() {
            return new KnowledgeBaseFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
