/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations to override prompts in different parts of an agent sequence. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptOverrideConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptOverrideConfiguration.Builder, PromptOverrideConfiguration> {
    private static final SdkField<String> OVERRIDE_LAMBDA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideLambda").getter(getter(PromptOverrideConfiguration::overrideLambda))
            .setter(setter(Builder::overrideLambda))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLambda").build()).build();

    private static final SdkField<List<PromptConfiguration>> PROMPT_CONFIGURATIONS_FIELD = SdkField
            .<List<PromptConfiguration>> builder(MarshallingType.LIST)
            .memberName("promptConfigurations")
            .getter(getter(PromptOverrideConfiguration::promptConfigurations))
            .setter(setter(Builder::promptConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_LAMBDA_FIELD,
            PROMPT_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String overrideLambda;

    private final List<PromptConfiguration> promptConfigurations;

    private PromptOverrideConfiguration(BuilderImpl builder) {
        this.overrideLambda = builder.overrideLambda;
        this.promptConfigurations = builder.promptConfigurations;
    }

    /**
     * <p>
     * The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent
     * sequence. If you specify this field, at least one of the <code>promptConfigurations</code> must contain a
     * <code>parserMode</code> value that is set to <code>OVERRIDDEN</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda function in Amazon
     * Bedrock Agents</a>.
     * </p>
     * 
     * @return The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent
     *         sequence. If you specify this field, at least one of the <code>promptConfigurations</code> must contain a
     *         <code>parserMode</code> value that is set to <code>OVERRIDDEN</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda function in
     *         Amazon Bedrock Agents</a>.
     */
    public final String overrideLambda() {
        return overrideLambda;
    }

    /**
     * For responses, this returns true if the service returned a value for the PromptConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPromptConfigurations() {
        return promptConfigurations != null && !(promptConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains configurations to override a prompt template in one part of an agent sequence. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptConfigurations} method.
     * </p>
     * 
     * @return Contains configurations to override a prompt template in one part of an agent sequence. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     */
    public final List<PromptConfiguration> promptConfigurations() {
        return promptConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(overrideLambda());
        hashCode = 31 * hashCode + Objects.hashCode(hasPromptConfigurations() ? promptConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptOverrideConfiguration)) {
            return false;
        }
        PromptOverrideConfiguration other = (PromptOverrideConfiguration) obj;
        return Objects.equals(overrideLambda(), other.overrideLambda())
                && hasPromptConfigurations() == other.hasPromptConfigurations()
                && Objects.equals(promptConfigurations(), other.promptConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptOverrideConfiguration").add("OverrideLambda", overrideLambda())
                .add("PromptConfigurations", hasPromptConfigurations() ? promptConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "overrideLambda":
            return Optional.ofNullable(clazz.cast(overrideLambda()));
        case "promptConfigurations":
            return Optional.ofNullable(clazz.cast(promptConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptOverrideConfiguration, T> g) {
        return obj -> g.apply((PromptOverrideConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptOverrideConfiguration> {
        /**
         * <p>
         * The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent
         * sequence. If you specify this field, at least one of the <code>promptConfigurations</code> must contain a
         * <code>parserMode</code> value that is set to <code>OVERRIDDEN</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda function in
         * Amazon Bedrock Agents</a>.
         * </p>
         * 
         * @param overrideLambda
         *        The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the
         *        agent sequence. If you specify this field, at least one of the <code>promptConfigurations</code> must
         *        contain a <code>parserMode</code> value that is set to <code>OVERRIDDEN</code>. For more information,
         *        see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html">Parser Lambda
         *        function in Amazon Bedrock Agents</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideLambda(String overrideLambda);

        /**
         * <p>
         * Contains configurations to override a prompt template in one part of an agent sequence. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         * prompts</a>.
         * </p>
         * 
         * @param promptConfigurations
         *        Contains configurations to override a prompt template in one part of an agent sequence. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         *        prompts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptConfigurations(Collection<PromptConfiguration> promptConfigurations);

        /**
         * <p>
         * Contains configurations to override a prompt template in one part of an agent sequence. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         * prompts</a>.
         * </p>
         * 
         * @param promptConfigurations
         *        Contains configurations to override a prompt template in one part of an agent sequence. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         *        prompts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptConfigurations(PromptConfiguration... promptConfigurations);

        /**
         * <p>
         * Contains configurations to override a prompt template in one part of an agent sequence. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         * prompts</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #promptConfigurations(List<PromptConfiguration>)}.
         * 
         * @param promptConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.PromptConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptConfigurations(java.util.Collection<PromptConfiguration>)
         */
        Builder promptConfigurations(Consumer<PromptConfiguration.Builder>... promptConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String overrideLambda;

        private List<PromptConfiguration> promptConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PromptOverrideConfiguration model) {
            overrideLambda(model.overrideLambda);
            promptConfigurations(model.promptConfigurations);
        }

        public final String getOverrideLambda() {
            return overrideLambda;
        }

        public final void setOverrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
        }

        @Override
        public final Builder overrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
            return this;
        }

        public final List<PromptConfiguration.Builder> getPromptConfigurations() {
            List<PromptConfiguration.Builder> result = PromptConfigurationsCopier.copyToBuilder(this.promptConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptConfigurations(Collection<PromptConfiguration.BuilderImpl> promptConfigurations) {
            this.promptConfigurations = PromptConfigurationsCopier.copyFromBuilder(promptConfigurations);
        }

        @Override
        public final Builder promptConfigurations(Collection<PromptConfiguration> promptConfigurations) {
            this.promptConfigurations = PromptConfigurationsCopier.copy(promptConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptConfigurations(PromptConfiguration... promptConfigurations) {
            promptConfigurations(Arrays.asList(promptConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptConfigurations(Consumer<PromptConfiguration.Builder>... promptConfigurations) {
            promptConfigurations(Stream.of(promptConfigurations).map(c -> PromptConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PromptOverrideConfiguration build() {
            return new PromptOverrideConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
