/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the URL/URLs for the web content that you want to crawl. You should be authorized to crawl the
 * URLs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WebSourceConfiguration.Builder, WebSourceConfiguration> {
    private static final SdkField<UrlConfiguration> URL_CONFIGURATION_FIELD = SdkField
            .<UrlConfiguration> builder(MarshallingType.SDK_POJO).memberName("urlConfiguration")
            .getter(getter(WebSourceConfiguration::urlConfiguration)).setter(setter(Builder::urlConfiguration))
            .constructor(UrlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final UrlConfiguration urlConfiguration;

    private WebSourceConfiguration(BuilderImpl builder) {
        this.urlConfiguration = builder.urlConfiguration;
    }

    /**
     * <p>
     * The configuration of the URL/URLs.
     * </p>
     * 
     * @return The configuration of the URL/URLs.
     */
    public final UrlConfiguration urlConfiguration() {
        return urlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(urlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebSourceConfiguration)) {
            return false;
        }
        WebSourceConfiguration other = (WebSourceConfiguration) obj;
        return Objects.equals(urlConfiguration(), other.urlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebSourceConfiguration").add("UrlConfiguration", urlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "urlConfiguration":
            return Optional.ofNullable(clazz.cast(urlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebSourceConfiguration, T> g) {
        return obj -> g.apply((WebSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebSourceConfiguration> {
        /**
         * <p>
         * The configuration of the URL/URLs.
         * </p>
         * 
         * @param urlConfiguration
         *        The configuration of the URL/URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlConfiguration(UrlConfiguration urlConfiguration);

        /**
         * <p>
         * The configuration of the URL/URLs.
         * </p>
         * This is a convenience method that creates an instance of the {@link UrlConfiguration.Builder} avoiding the
         * need to create one manually via {@link UrlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UrlConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #urlConfiguration(UrlConfiguration)}.
         * 
         * @param urlConfiguration
         *        a consumer that will call methods on {@link UrlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urlConfiguration(UrlConfiguration)
         */
        default Builder urlConfiguration(Consumer<UrlConfiguration.Builder> urlConfiguration) {
            return urlConfiguration(UrlConfiguration.builder().applyMutation(urlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UrlConfiguration urlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WebSourceConfiguration model) {
            urlConfiguration(model.urlConfiguration);
        }

        public final UrlConfiguration.Builder getUrlConfiguration() {
            return urlConfiguration != null ? urlConfiguration.toBuilder() : null;
        }

        public final void setUrlConfiguration(UrlConfiguration.BuilderImpl urlConfiguration) {
            this.urlConfiguration = urlConfiguration != null ? urlConfiguration.build() : null;
        }

        @Override
        public final Builder urlConfiguration(UrlConfiguration urlConfiguration) {
            this.urlConfiguration = urlConfiguration;
            return this;
        }

        @Override
        public WebSourceConfiguration build() {
            return new WebSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
