/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftProvisionedAuthConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftProvisionedConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftProvisionedConfiguration> {
    private static final SdkField<RedshiftProvisionedAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authConfiguration").getter(RedshiftProvisionedConfiguration.getter(RedshiftProvisionedConfiguration::authConfiguration)).setter(RedshiftProvisionedConfiguration.setter(Builder::authConfiguration)).constructor(RedshiftProvisionedAuthConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterIdentifier").getter(RedshiftProvisionedConfiguration.getter(RedshiftProvisionedConfiguration::clusterIdentifier)).setter(RedshiftProvisionedConfiguration.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CONFIGURATION_FIELD, CLUSTER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
            this.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RedshiftProvisionedAuthConfiguration authConfiguration;
    private final String clusterIdentifier;

    private RedshiftProvisionedConfiguration(BuilderImpl builder) {
        this.authConfiguration = builder.authConfiguration;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    public final RedshiftProvisionedAuthConfiguration authConfiguration() {
        return this.authConfiguration;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftProvisionedConfiguration)) {
            return false;
        }
        RedshiftProvisionedConfiguration other = (RedshiftProvisionedConfiguration)obj;
        return Objects.equals(this.authConfiguration(), other.authConfiguration()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftProvisionedConfiguration").add("AuthConfiguration", (Object)this.authConfiguration()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authConfiguration()));
            }
            case "clusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftProvisionedConfiguration, T> g) {
        return obj -> g.apply((RedshiftProvisionedConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftProvisionedAuthConfiguration authConfiguration;
        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftProvisionedConfiguration model) {
            this.authConfiguration(model.authConfiguration);
            this.clusterIdentifier(model.clusterIdentifier);
        }

        public final RedshiftProvisionedAuthConfiguration.Builder getAuthConfiguration() {
            return this.authConfiguration != null ? this.authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(RedshiftProvisionedAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(RedshiftProvisionedAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public RedshiftProvisionedConfiguration build() {
            return new RedshiftProvisionedConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftProvisionedConfiguration> {
        public Builder authConfiguration(RedshiftProvisionedAuthConfiguration var1);

        default public Builder authConfiguration(Consumer<RedshiftProvisionedAuthConfiguration.Builder> authConfiguration) {
            return this.authConfiguration((RedshiftProvisionedAuthConfiguration)((RedshiftProvisionedAuthConfiguration.Builder)RedshiftProvisionedAuthConfiguration.builder().applyMutation(authConfiguration)).build());
        }

        public Builder clusterIdentifier(String var1);
    }
}

