/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentSummary implements SdkPojo, Serializable, ToCopyableBuilder<AgentSummary.Builder, AgentSummary> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentSummary::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentName").getter(getter(AgentSummary::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()).build();

    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentStatus").getter(getter(AgentSummary::agentStatusAsString)).setter(setter(Builder::agentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(AgentSummary::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<String> LATEST_AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestAgentVersion").getter(getter(AgentSummary::latestAgentVersion))
            .setter(setter(Builder::latestAgentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAgentVersion").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_NAME_FIELD, AGENT_STATUS_FIELD, DESCRIPTION_FIELD, GUARDRAIL_CONFIGURATION_FIELD, LATEST_AGENT_VERSION_FIELD,
            UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String agentName;

    private final String agentStatus;

    private final String description;

    private final GuardrailConfiguration guardrailConfiguration;

    private final String latestAgentVersion;

    private final Instant updatedAt;

    private AgentSummary(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentName = builder.agentName;
        this.agentStatus = builder.agentStatus;
        this.description = builder.description;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.latestAgentVersion = builder.latestAgentVersion;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The unique identifier of the agent.
     * </p>
     * 
     * @return The unique identifier of the agent.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The name of the agent.
     * </p>
     * 
     * @return The name of the agent.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * <p>
     * The status of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The status of the agent.
     * @see AgentStatus
     */
    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(agentStatus);
    }

    /**
     * <p>
     * The status of the agent.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return The status of the agent.
     * @see AgentStatus
     */
    public final String agentStatusAsString() {
        return agentStatus;
    }

    /**
     * <p>
     * The description of the agent.
     * </p>
     * 
     * @return The description of the agent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Details about the guardrail associated with the agent.
     * </p>
     * 
     * @return Details about the guardrail associated with the agent.
     */
    public final GuardrailConfiguration guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * The latest version of the agent.
     * </p>
     * 
     * @return The latest version of the agent.
     */
    public final String latestAgentVersion() {
        return latestAgentVersion;
    }

    /**
     * <p>
     * The time at which the agent was last updated.
     * </p>
     * 
     * @return The time at which the agent was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(latestAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentSummary)) {
            return false;
        }
        AgentSummary other = (AgentSummary) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentName(), other.agentName())
                && Objects.equals(agentStatusAsString(), other.agentStatusAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(latestAgentVersion(), other.latestAgentVersion())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentSummary").add("AgentId", agentId()).add("AgentName", agentName())
                .add("AgentStatus", agentStatusAsString()).add("Description", description())
                .add("GuardrailConfiguration", guardrailConfiguration()).add("LatestAgentVersion", latestAgentVersion())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "agentStatus":
            return Optional.ofNullable(clazz.cast(agentStatusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "latestAgentVersion":
            return Optional.ofNullable(clazz.cast(latestAgentVersion()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("agentStatus", AGENT_STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("latestAgentVersion", LATEST_AGENT_VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentSummary, T> g) {
        return obj -> g.apply((AgentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentSummary> {
        /**
         * <p>
         * The unique identifier of the agent.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The name of the agent.
         * </p>
         * 
         * @param agentName
         *        The name of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * <p>
         * The status of the agent.
         * </p>
         * 
         * @param agentStatus
         *        The status of the agent.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(String agentStatus);

        /**
         * <p>
         * The status of the agent.
         * </p>
         * 
         * @param agentStatus
         *        The status of the agent.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(AgentStatus agentStatus);

        /**
         * <p>
         * The description of the agent.
         * </p>
         * 
         * @param description
         *        The description of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Details about the guardrail associated with the agent.
         * </p>
         * 
         * @param guardrailConfiguration
         *        Details about the guardrail associated with the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration);

        /**
         * <p>
         * Details about the guardrail associated with the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfiguration.Builder} avoiding
         * the need to create one manually via {@link GuardrailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #guardrailConfiguration(GuardrailConfiguration)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfiguration)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfiguration.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * The latest version of the agent.
         * </p>
         * 
         * @param latestAgentVersion
         *        The latest version of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAgentVersion(String latestAgentVersion);

        /**
         * <p>
         * The time at which the agent was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the agent was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String agentName;

        private String agentStatus;

        private String description;

        private GuardrailConfiguration guardrailConfiguration;

        private String latestAgentVersion;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentSummary model) {
            agentId(model.agentId);
            agentName(model.agentName);
            agentStatus(model.agentStatus);
            description(model.description);
            guardrailConfiguration(model.guardrailConfiguration);
            latestAgentVersion(model.latestAgentVersion);
            updatedAt(model.updatedAt);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getAgentStatus() {
            return agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final String getLatestAgentVersion() {
            return latestAgentVersion;
        }

        public final void setLatestAgentVersion(String latestAgentVersion) {
            this.latestAgentVersion = latestAgentVersion;
        }

        @Override
        public final Builder latestAgentVersion(String latestAgentVersion) {
            this.latestAgentVersion = latestAgentVersion;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public AgentSummary build() {
            return new AgentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
