/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAgentCollaboratorRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<AssociateAgentCollaboratorRequest.Builder, AssociateAgentCollaboratorRequest> {
    private static final SdkField<AgentDescriptor> AGENT_DESCRIPTOR_FIELD = SdkField
            .<AgentDescriptor> builder(MarshallingType.SDK_POJO).memberName("agentDescriptor")
            .getter(getter(AssociateAgentCollaboratorRequest::agentDescriptor)).setter(setter(Builder::agentDescriptor))
            .constructor(AgentDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDescriptor").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AssociateAgentCollaboratorRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AssociateAgentCollaboratorRequest::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(AssociateAgentCollaboratorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> COLLABORATION_INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationInstruction").getter(getter(AssociateAgentCollaboratorRequest::collaborationInstruction))
            .setter(setter(Builder::collaborationInstruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationInstruction").build())
            .build();

    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorName").getter(getter(AssociateAgentCollaboratorRequest::collaboratorName))
            .setter(setter(Builder::collaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()).build();

    private static final SdkField<String> RELAY_CONVERSATION_HISTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relayConversationHistory")
            .getter(getter(AssociateAgentCollaboratorRequest::relayConversationHistoryAsString))
            .setter(setter(Builder::relayConversationHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relayConversationHistory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_DESCRIPTOR_FIELD,
            AGENT_ID_FIELD, AGENT_VERSION_FIELD, CLIENT_TOKEN_FIELD, COLLABORATION_INSTRUCTION_FIELD, COLLABORATOR_NAME_FIELD,
            RELAY_CONVERSATION_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AgentDescriptor agentDescriptor;

    private final String agentId;

    private final String agentVersion;

    private final String clientToken;

    private final String collaborationInstruction;

    private final String collaboratorName;

    private final String relayConversationHistory;

    private AssociateAgentCollaboratorRequest(BuilderImpl builder) {
        super(builder);
        this.agentDescriptor = builder.agentDescriptor;
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.clientToken = builder.clientToken;
        this.collaborationInstruction = builder.collaborationInstruction;
        this.collaboratorName = builder.collaboratorName;
        this.relayConversationHistory = builder.relayConversationHistory;
    }

    /**
     * <p>
     * The alias of the collaborator agent.
     * </p>
     * 
     * @return The alias of the collaborator agent.
     */
    public final AgentDescriptor agentDescriptor() {
        return agentDescriptor;
    }

    /**
     * <p>
     * The agent's ID.
     * </p>
     * 
     * @return The agent's ID.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * An agent version.
     * </p>
     * 
     * @return An agent version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Instruction for the collaborator.
     * </p>
     * 
     * @return Instruction for the collaborator.
     */
    public final String collaborationInstruction() {
        return collaborationInstruction;
    }

    /**
     * <p>
     * A name for the collaborator.
     * </p>
     * 
     * @return A name for the collaborator.
     */
    public final String collaboratorName() {
        return collaboratorName;
    }

    /**
     * <p>
     * A relay conversation history for the collaborator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relayConversationHistory} will return {@link RelayConversationHistory#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #relayConversationHistoryAsString}.
     * </p>
     * 
     * @return A relay conversation history for the collaborator.
     * @see RelayConversationHistory
     */
    public final RelayConversationHistory relayConversationHistory() {
        return RelayConversationHistory.fromValue(relayConversationHistory);
    }

    /**
     * <p>
     * A relay conversation history for the collaborator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relayConversationHistory} will return {@link RelayConversationHistory#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #relayConversationHistoryAsString}.
     * </p>
     * 
     * @return A relay conversation history for the collaborator.
     * @see RelayConversationHistory
     */
    public final String relayConversationHistoryAsString() {
        return relayConversationHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(relayConversationHistoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAgentCollaboratorRequest)) {
            return false;
        }
        AssociateAgentCollaboratorRequest other = (AssociateAgentCollaboratorRequest) obj;
        return Objects.equals(agentDescriptor(), other.agentDescriptor()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(collaborationInstruction(), other.collaborationInstruction())
                && Objects.equals(collaboratorName(), other.collaboratorName())
                && Objects.equals(relayConversationHistoryAsString(), other.relayConversationHistoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAgentCollaboratorRequest").add("AgentDescriptor", agentDescriptor())
                .add("AgentId", agentId()).add("AgentVersion", agentVersion()).add("ClientToken", clientToken())
                .add("CollaborationInstruction", collaborationInstruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CollaboratorName", collaboratorName()).add("RelayConversationHistory", relayConversationHistoryAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentDescriptor":
            return Optional.ofNullable(clazz.cast(agentDescriptor()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "collaborationInstruction":
            return Optional.ofNullable(clazz.cast(collaborationInstruction()));
        case "collaboratorName":
            return Optional.ofNullable(clazz.cast(collaboratorName()));
        case "relayConversationHistory":
            return Optional.ofNullable(clazz.cast(relayConversationHistoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentDescriptor", AGENT_DESCRIPTOR_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("collaborationInstruction", COLLABORATION_INSTRUCTION_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("relayConversationHistory", RELAY_CONVERSATION_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAgentCollaboratorRequest, T> g) {
        return obj -> g.apply((AssociateAgentCollaboratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAgentCollaboratorRequest> {
        /**
         * <p>
         * The alias of the collaborator agent.
         * </p>
         * 
         * @param agentDescriptor
         *        The alias of the collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentDescriptor(AgentDescriptor agentDescriptor);

        /**
         * <p>
         * The alias of the collaborator agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentDescriptor.Builder} avoiding the
         * need to create one manually via {@link AgentDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentDescriptor.Builder#build()} is called immediately and its
         * result is passed to {@link #agentDescriptor(AgentDescriptor)}.
         * 
         * @param agentDescriptor
         *        a consumer that will call methods on {@link AgentDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentDescriptor(AgentDescriptor)
         */
        default Builder agentDescriptor(Consumer<AgentDescriptor.Builder> agentDescriptor) {
            return agentDescriptor(AgentDescriptor.builder().applyMutation(agentDescriptor).build());
        }

        /**
         * <p>
         * The agent's ID.
         * </p>
         * 
         * @param agentId
         *        The agent's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * An agent version.
         * </p>
         * 
         * @param agentVersion
         *        An agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Instruction for the collaborator.
         * </p>
         * 
         * @param collaborationInstruction
         *        Instruction for the collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationInstruction(String collaborationInstruction);

        /**
         * <p>
         * A name for the collaborator.
         * </p>
         * 
         * @param collaboratorName
         *        A name for the collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorName(String collaboratorName);

        /**
         * <p>
         * A relay conversation history for the collaborator.
         * </p>
         * 
         * @param relayConversationHistory
         *        A relay conversation history for the collaborator.
         * @see RelayConversationHistory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelayConversationHistory
         */
        Builder relayConversationHistory(String relayConversationHistory);

        /**
         * <p>
         * A relay conversation history for the collaborator.
         * </p>
         * 
         * @param relayConversationHistory
         *        A relay conversation history for the collaborator.
         * @see RelayConversationHistory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelayConversationHistory
         */
        Builder relayConversationHistory(RelayConversationHistory relayConversationHistory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private AgentDescriptor agentDescriptor;

        private String agentId;

        private String agentVersion;

        private String clientToken;

        private String collaborationInstruction;

        private String collaboratorName;

        private String relayConversationHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAgentCollaboratorRequest model) {
            super(model);
            agentDescriptor(model.agentDescriptor);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            clientToken(model.clientToken);
            collaborationInstruction(model.collaborationInstruction);
            collaboratorName(model.collaboratorName);
            relayConversationHistory(model.relayConversationHistory);
        }

        public final AgentDescriptor.Builder getAgentDescriptor() {
            return agentDescriptor != null ? agentDescriptor.toBuilder() : null;
        }

        public final void setAgentDescriptor(AgentDescriptor.BuilderImpl agentDescriptor) {
            this.agentDescriptor = agentDescriptor != null ? agentDescriptor.build() : null;
        }

        @Override
        public final Builder agentDescriptor(AgentDescriptor agentDescriptor) {
            this.agentDescriptor = agentDescriptor;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCollaborationInstruction() {
            return collaborationInstruction;
        }

        public final void setCollaborationInstruction(String collaborationInstruction) {
            this.collaborationInstruction = collaborationInstruction;
        }

        @Override
        public final Builder collaborationInstruction(String collaborationInstruction) {
            this.collaborationInstruction = collaborationInstruction;
            return this;
        }

        public final String getCollaboratorName() {
            return collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getRelayConversationHistory() {
            return relayConversationHistory;
        }

        public final void setRelayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
        }

        @Override
        public final Builder relayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
            return this;
        }

        @Override
        public final Builder relayConversationHistory(RelayConversationHistory relayConversationHistory) {
            this.relayConversationHistory(relayConversationHistory == null ? null : relayConversationHistory.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAgentCollaboratorRequest build() {
            return new AssociateAgentCollaboratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
