/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAgentCollaboratorResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<AssociateAgentCollaboratorResponse.Builder, AssociateAgentCollaboratorResponse> {
    private static final SdkField<AgentCollaborator> AGENT_COLLABORATOR_FIELD = SdkField
            .<AgentCollaborator> builder(MarshallingType.SDK_POJO).memberName("agentCollaborator")
            .getter(getter(AssociateAgentCollaboratorResponse::agentCollaborator)).setter(setter(Builder::agentCollaborator))
            .constructor(AgentCollaborator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaborator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_COLLABORATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AgentCollaborator agentCollaborator;

    private AssociateAgentCollaboratorResponse(BuilderImpl builder) {
        super(builder);
        this.agentCollaborator = builder.agentCollaborator;
    }

    /**
     * <p>
     * Details about the collaborator.
     * </p>
     * 
     * @return Details about the collaborator.
     */
    public final AgentCollaborator agentCollaborator() {
        return agentCollaborator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaborator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAgentCollaboratorResponse)) {
            return false;
        }
        AssociateAgentCollaboratorResponse other = (AssociateAgentCollaboratorResponse) obj;
        return Objects.equals(agentCollaborator(), other.agentCollaborator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAgentCollaboratorResponse").add("AgentCollaborator", agentCollaborator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentCollaborator":
            return Optional.ofNullable(clazz.cast(agentCollaborator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentCollaborator", AGENT_COLLABORATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAgentCollaboratorResponse, T> g) {
        return obj -> g.apply((AssociateAgentCollaboratorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAgentCollaboratorResponse> {
        /**
         * <p>
         * Details about the collaborator.
         * </p>
         * 
         * @param agentCollaborator
         *        Details about the collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCollaborator(AgentCollaborator agentCollaborator);

        /**
         * <p>
         * Details about the collaborator.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentCollaborator.Builder} avoiding the
         * need to create one manually via {@link AgentCollaborator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentCollaborator.Builder#build()} is called immediately and its
         * result is passed to {@link #agentCollaborator(AgentCollaborator)}.
         * 
         * @param agentCollaborator
         *        a consumer that will call methods on {@link AgentCollaborator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentCollaborator(AgentCollaborator)
         */
        default Builder agentCollaborator(Consumer<AgentCollaborator.Builder> agentCollaborator) {
            return agentCollaborator(AgentCollaborator.builder().applyMutation(agentCollaborator).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private AgentCollaborator agentCollaborator;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAgentCollaboratorResponse model) {
            super(model);
            agentCollaborator(model.agentCollaborator);
        }

        public final AgentCollaborator.Builder getAgentCollaborator() {
            return agentCollaborator != null ? agentCollaborator.toBuilder() : null;
        }

        public final void setAgentCollaborator(AgentCollaborator.BuilderImpl agentCollaborator) {
            this.agentCollaborator = agentCollaborator != null ? agentCollaborator.build() : null;
        }

        @Override
        public final Builder agentCollaborator(AgentCollaborator agentCollaborator) {
            this.agentCollaborator = agentCollaborator;
            return this;
        }

        @Override
        public AssociateAgentCollaboratorResponse build() {
            return new AssociateAgentCollaboratorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
