/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAgentKnowledgeBaseRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<AssociateAgentKnowledgeBaseRequest.Builder, AssociateAgentKnowledgeBaseRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AssociateAgentKnowledgeBaseRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AssociateAgentKnowledgeBaseRequest::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssociateAgentKnowledgeBaseRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(AssociateAgentKnowledgeBaseRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseState").getter(getter(AssociateAgentKnowledgeBaseRequest::knowledgeBaseStateAsString))
            .setter(setter(Builder::knowledgeBaseState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_ID_FIELD, KNOWLEDGE_BASE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentId;

    private final String agentVersion;

    private final String description;

    private final String knowledgeBaseId;

    private final String knowledgeBaseState;

    private AssociateAgentKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.description = builder.description;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseState = builder.knowledgeBaseState;
    }

    /**
     * <p>
     * The unique identifier of the agent with which you want to associate the knowledge base.
     * </p>
     * 
     * @return The unique identifier of the agent with which you want to associate the knowledge base.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The version of the agent with which you want to associate the knowledge base.
     * </p>
     * 
     * @return The version of the agent with which you want to associate the knowledge base.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * A description of what the agent should use the knowledge base for.
     * </p>
     * 
     * @return A description of what the agent should use the knowledge base for.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base to associate with the agent.
     * </p>
     * 
     * @return The unique identifier of the knowledge base to associate with the agent.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * Specifies whether to use the knowledge base or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return Specifies whether to use the knowledge base or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see KnowledgeBaseState
     */
    public final KnowledgeBaseState knowledgeBaseState() {
        return KnowledgeBaseState.fromValue(knowledgeBaseState);
    }

    /**
     * <p>
     * Specifies whether to use the knowledge base or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return Specifies whether to use the knowledge base or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see KnowledgeBaseState
     */
    public final String knowledgeBaseStateAsString() {
        return knowledgeBaseState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAgentKnowledgeBaseRequest)) {
            return false;
        }
        AssociateAgentKnowledgeBaseRequest other = (AssociateAgentKnowledgeBaseRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(knowledgeBaseStateAsString(), other.knowledgeBaseStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAgentKnowledgeBaseRequest").add("AgentId", agentId())
                .add("AgentVersion", agentVersion()).add("Description", description()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("KnowledgeBaseState", knowledgeBaseStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "knowledgeBaseState":
            return Optional.ofNullable(clazz.cast(knowledgeBaseStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseState", KNOWLEDGE_BASE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAgentKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((AssociateAgentKnowledgeBaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateAgentKnowledgeBaseRequest> {
        /**
         * <p>
         * The unique identifier of the agent with which you want to associate the knowledge base.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent with which you want to associate the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The version of the agent with which you want to associate the knowledge base.
         * </p>
         * 
         * @param agentVersion
         *        The version of the agent with which you want to associate the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * A description of what the agent should use the knowledge base for.
         * </p>
         * 
         * @param description
         *        A description of what the agent should use the knowledge base for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the knowledge base to associate with the agent.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base to associate with the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * Specifies whether to use the knowledge base or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param knowledgeBaseState
         *        Specifies whether to use the knowledge base or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         *        >InvokeAgent</a> request.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(String knowledgeBaseState);

        /**
         * <p>
         * Specifies whether to use the knowledge base or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param knowledgeBaseState
         *        Specifies whether to use the knowledge base or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         *        >InvokeAgent</a> request.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String description;

        private String knowledgeBaseId;

        private String knowledgeBaseState;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAgentKnowledgeBaseRequest model) {
            super(model);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            description(model.description);
            knowledgeBaseId(model.knowledgeBaseId);
            knowledgeBaseState(model.knowledgeBaseState);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseState() {
            return knowledgeBaseState;
        }

        public final void setKnowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
        }

        @Override
        public final Builder knowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
            return this;
        }

        @Override
        public final Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState) {
            this.knowledgeBaseState(knowledgeBaseState == null ? null : knowledgeBaseState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAgentKnowledgeBaseRequest build() {
            return new AssociateAgentKnowledgeBaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
