/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations to use a prompt in a conversational format. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt using
 * Prompt management</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatPromptTemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChatPromptTemplateConfiguration.Builder, ChatPromptTemplateConfiguration> {
    private static final SdkField<List<PromptInputVariable>> INPUT_VARIABLES_FIELD = SdkField
            .<List<PromptInputVariable>> builder(MarshallingType.LIST)
            .memberName("inputVariables")
            .getter(getter(ChatPromptTemplateConfiguration::inputVariables))
            .setter(setter(Builder::inputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptInputVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptInputVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(ChatPromptTemplateConfiguration::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField
            .<List<SystemContentBlock>> builder(MarshallingType.LIST)
            .memberName("system")
            .getter(getter(ChatPromptTemplateConfiguration::system))
            .setter(setter(Builder::system))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SystemContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(SystemContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ToolConfiguration> TOOL_CONFIGURATION_FIELD = SdkField
            .<ToolConfiguration> builder(MarshallingType.SDK_POJO).memberName("toolConfiguration")
            .getter(getter(ChatPromptTemplateConfiguration::toolConfiguration)).setter(setter(Builder::toolConfiguration))
            .constructor(ToolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_VARIABLES_FIELD,
            MESSAGES_FIELD, SYSTEM_FIELD, TOOL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PromptInputVariable> inputVariables;

    private final List<Message> messages;

    private final List<SystemContentBlock> system;

    private final ToolConfiguration toolConfiguration;

    private ChatPromptTemplateConfiguration(BuilderImpl builder) {
        this.inputVariables = builder.inputVariables;
        this.messages = builder.messages;
        this.system = builder.system;
        this.toolConfiguration = builder.toolConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputVariables() {
        return inputVariables != null && !(inputVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the variables in the prompt template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputVariables} method.
     * </p>
     * 
     * @return An array of the variables in the prompt template.
     */
    public final List<PromptInputVariable> inputVariables() {
        return inputVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains messages in the chat for the prompt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return Contains messages in the chat for the prompt.
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * For responses, this returns true if the service returned a value for the System property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSystem() {
        return system != null && !(system instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains system prompts to provide context to the model or to describe how it should behave.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSystem} method.
     * </p>
     * 
     * @return Contains system prompts to provide context to the model or to describe how it should behave.
     */
    public final List<SystemContentBlock> system() {
        return system;
    }

    /**
     * <p>
     * Configuration information for the tools that the model can use when generating a response.
     * </p>
     * 
     * @return Configuration information for the tools that the model can use when generating a response.
     */
    public final ToolConfiguration toolConfiguration() {
        return toolConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputVariables() ? inputVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSystem() ? system() : null);
        hashCode = 31 * hashCode + Objects.hashCode(toolConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatPromptTemplateConfiguration)) {
            return false;
        }
        ChatPromptTemplateConfiguration other = (ChatPromptTemplateConfiguration) obj;
        return hasInputVariables() == other.hasInputVariables() && Objects.equals(inputVariables(), other.inputVariables())
                && hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && hasSystem() == other.hasSystem() && Objects.equals(system(), other.system())
                && Objects.equals(toolConfiguration(), other.toolConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatPromptTemplateConfiguration")
                .add("InputVariables", inputVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Messages", hasMessages() ? messages() : null)
                .add("System", system() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ToolConfiguration", toolConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputVariables":
            return Optional.ofNullable(clazz.cast(inputVariables()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "system":
            return Optional.ofNullable(clazz.cast(system()));
        case "toolConfiguration":
            return Optional.ofNullable(clazz.cast(toolConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputVariables", INPUT_VARIABLES_FIELD);
        map.put("messages", MESSAGES_FIELD);
        map.put("system", SYSTEM_FIELD);
        map.put("toolConfiguration", TOOL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatPromptTemplateConfiguration, T> g) {
        return obj -> g.apply((ChatPromptTemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatPromptTemplateConfiguration> {
        /**
         * <p>
         * An array of the variables in the prompt template.
         * </p>
         * 
         * @param inputVariables
         *        An array of the variables in the prompt template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputVariables(Collection<PromptInputVariable> inputVariables);

        /**
         * <p>
         * An array of the variables in the prompt template.
         * </p>
         * 
         * @param inputVariables
         *        An array of the variables in the prompt template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputVariables(PromptInputVariable... inputVariables);

        /**
         * <p>
         * An array of the variables in the prompt template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable.Builder#build()} is called
         * immediately and its result is passed to {@link #inputVariables(List<PromptInputVariable>)}.
         * 
         * @param inputVariables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputVariables(java.util.Collection<PromptInputVariable>)
         */
        Builder inputVariables(Consumer<PromptInputVariable.Builder>... inputVariables);

        /**
         * <p>
         * Contains messages in the chat for the prompt.
         * </p>
         * 
         * @param messages
         *        Contains messages in the chat for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * Contains messages in the chat for the prompt.
         * </p>
         * 
         * @param messages
         *        Contains messages in the chat for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * Contains messages in the chat for the prompt.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockagent.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.Message.Builder#build()} is called immediately and
         * its result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * <p>
         * Contains system prompts to provide context to the model or to describe how it should behave.
         * </p>
         * 
         * @param system
         *        Contains system prompts to provide context to the model or to describe how it should behave.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(Collection<SystemContentBlock> system);

        /**
         * <p>
         * Contains system prompts to provide context to the model or to describe how it should behave.
         * </p>
         * 
         * @param system
         *        Contains system prompts to provide context to the model or to describe how it should behave.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder system(SystemContentBlock... system);

        /**
         * <p>
         * Contains system prompts to provide context to the model or to describe how it should behave.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.SystemContentBlock.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.SystemContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.SystemContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #system(List<SystemContentBlock>)}.
         * 
         * @param system
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.SystemContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #system(java.util.Collection<SystemContentBlock>)
         */
        Builder system(Consumer<SystemContentBlock.Builder>... system);

        /**
         * <p>
         * Configuration information for the tools that the model can use when generating a response.
         * </p>
         * 
         * @param toolConfiguration
         *        Configuration information for the tools that the model can use when generating a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolConfiguration(ToolConfiguration toolConfiguration);

        /**
         * <p>
         * Configuration information for the tools that the model can use when generating a response.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolConfiguration.Builder} avoiding the
         * need to create one manually via {@link ToolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #toolConfiguration(ToolConfiguration)}.
         * 
         * @param toolConfiguration
         *        a consumer that will call methods on {@link ToolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolConfiguration(ToolConfiguration)
         */
        default Builder toolConfiguration(Consumer<ToolConfiguration.Builder> toolConfiguration) {
            return toolConfiguration(ToolConfiguration.builder().applyMutation(toolConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<PromptInputVariable> inputVariables = DefaultSdkAutoConstructList.getInstance();

        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();

        private ToolConfiguration toolConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatPromptTemplateConfiguration model) {
            inputVariables(model.inputVariables);
            messages(model.messages);
            system(model.system);
            toolConfiguration(model.toolConfiguration);
        }

        public final List<PromptInputVariable.Builder> getInputVariables() {
            List<PromptInputVariable.Builder> result = PromptInputVariablesListCopier.copyToBuilder(this.inputVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputVariables(Collection<PromptInputVariable.BuilderImpl> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copyFromBuilder(inputVariables);
        }

        @Override
        public final Builder inputVariables(Collection<PromptInputVariable> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copy(inputVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(PromptInputVariable... inputVariables) {
            inputVariables(Arrays.asList(inputVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(Consumer<PromptInputVariable.Builder>... inputVariables) {
            inputVariables(Stream.of(inputVariables).map(c -> PromptInputVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock... system) {
            system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder>... system) {
            system(Stream.of(system).map(c -> SystemContentBlock.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolConfiguration.Builder getToolConfiguration() {
            return toolConfiguration != null ? toolConfiguration.toBuilder() : null;
        }

        public final void setToolConfiguration(ToolConfiguration.BuilderImpl toolConfiguration) {
            this.toolConfiguration = toolConfiguration != null ? toolConfiguration.build() : null;
        }

        @Override
        public final Builder toolConfiguration(ToolConfiguration toolConfiguration) {
            this.toolConfiguration = toolConfiguration;
            return this;
        }

        @Override
        public ChatPromptTemplateConfiguration build() {
            return new ChatPromptTemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
