/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKnowledgeBaseRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<CreateKnowledgeBaseRequest.Builder, CreateKnowledgeBaseRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateKnowledgeBaseRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateKnowledgeBaseRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<KnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseConfiguration")
            .getter(getter(CreateKnowledgeBaseRequest::knowledgeBaseConfiguration))
            .setter(setter(Builder::knowledgeBaseConfiguration))
            .constructor(KnowledgeBaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateKnowledgeBaseRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateKnowledgeBaseRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<StorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField
            .<StorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storageConfiguration")
            .getter(getter(CreateKnowledgeBaseRequest::storageConfiguration)).setter(setter(Builder::storageConfiguration))
            .constructor(StorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateKnowledgeBaseRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STORAGE_CONFIGURATION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final KnowledgeBaseConfiguration knowledgeBaseConfiguration;

    private final String name;

    private final String roleArn;

    private final StorageConfiguration storageConfiguration;

    private final Map<String, String> tags;

    private CreateKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.storageConfiguration = builder.storageConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description of the knowledge base.
     * </p>
     * 
     * @return A description of the knowledge base.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Contains details about the embeddings model used for the knowledge base.
     * </p>
     * 
     * @return Contains details about the embeddings model used for the knowledge base.
     */
    public final KnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return knowledgeBaseConfiguration;
    }

    /**
     * <p>
     * A name for the knowledge base.
     * </p>
     * 
     * @return A name for the knowledge base.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge
     *         base.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Contains details about the configuration of the vector database used for the knowledge base.
     * </p>
     * 
     * @return Contains details about the configuration of the vector database used for the knowledge base.
     */
    public final StorageConfiguration storageConfiguration() {
        return storageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specify the key-value pairs for the tags that you want to attach to your knowledge base in this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specify the key-value pairs for the tags that you want to attach to your knowledge base in this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKnowledgeBaseRequest)) {
            return false;
        }
        CreateKnowledgeBaseRequest other = (CreateKnowledgeBaseRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration())
                && Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(storageConfiguration(), other.storageConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKnowledgeBaseRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("KnowledgeBaseConfiguration", knowledgeBaseConfiguration()).add("Name", name()).add("RoleArn", roleArn())
                .add("StorageConfiguration", storageConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "storageConfiguration":
            return Optional.ofNullable(clazz.cast(storageConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseConfiguration", KNOWLEDGE_BASE_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("storageConfiguration", STORAGE_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((CreateKnowledgeBaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateKnowledgeBaseRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description of the knowledge base.
         * </p>
         * 
         * @param description
         *        A description of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains details about the embeddings model used for the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseConfiguration
         *        Contains details about the embeddings model used for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration);

        /**
         * <p>
         * Contains details about the embeddings model used for the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseConfiguration.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #knowledgeBaseConfiguration(KnowledgeBaseConfiguration)}.
         * 
         * @param knowledgeBaseConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfiguration(KnowledgeBaseConfiguration)
         */
        default Builder knowledgeBaseConfiguration(Consumer<KnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return knowledgeBaseConfiguration(KnowledgeBaseConfiguration.builder().applyMutation(knowledgeBaseConfiguration)
                    .build());
        }

        /**
         * <p>
         * A name for the knowledge base.
         * </p>
         * 
         * @param name
         *        A name for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the knowledge
         * base.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the
         *        knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Contains details about the configuration of the vector database used for the knowledge base.
         * </p>
         * 
         * @param storageConfiguration
         *        Contains details about the configuration of the vector database used for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfiguration(StorageConfiguration storageConfiguration);

        /**
         * <p>
         * Contains details about the configuration of the vector database used for the knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfiguration(StorageConfiguration)}.
         * 
         * @param storageConfiguration
         *        a consumer that will call methods on {@link StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfiguration(StorageConfiguration)
         */
        default Builder storageConfiguration(Consumer<StorageConfiguration.Builder> storageConfiguration) {
            return storageConfiguration(StorageConfiguration.builder().applyMutation(storageConfiguration).build());
        }

        /**
         * <p>
         * Specify the key-value pairs for the tags that you want to attach to your knowledge base in this object.
         * </p>
         * 
         * @param tags
         *        Specify the key-value pairs for the tags that you want to attach to your knowledge base in this
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private KnowledgeBaseConfiguration knowledgeBaseConfiguration;

        private String name;

        private String roleArn;

        private StorageConfiguration storageConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKnowledgeBaseRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            name(model.name);
            roleArn(model.roleArn);
            storageConfiguration(model.storageConfiguration);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final KnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(KnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StorageConfiguration.Builder getStorageConfiguration() {
            return storageConfiguration != null ? storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(StorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(StorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKnowledgeBaseRequest build() {
            return new CreateKnowledgeBaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
