/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon S3 location of the file containing the content to ingest into a knowledge base
 * connected to a custom data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomS3Location implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomS3Location.Builder, CustomS3Location> {
    private static final SdkField<String> BUCKET_OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketOwnerAccountId").getter(getter(CustomS3Location::bucketOwnerAccountId))
            .setter(setter(Builder::bucketOwnerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketOwnerAccountId").build())
            .build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(CustomS3Location::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_OWNER_ACCOUNT_ID_FIELD,
            URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketOwnerAccountId;

    private final String uri;

    private CustomS3Location(BuilderImpl builder) {
        this.bucketOwnerAccountId = builder.bucketOwnerAccountId;
        this.uri = builder.uri;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that owns the S3 bucket containing the content to ingest.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that owns the S3 bucket containing the content to
     *         ingest.
     */
    public final String bucketOwnerAccountId() {
        return bucketOwnerAccountId;
    }

    /**
     * <p>
     * The S3 URI of the file containing the content to ingest.
     * </p>
     * 
     * @return The S3 URI of the file containing the content to ingest.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketOwnerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomS3Location)) {
            return false;
        }
        CustomS3Location other = (CustomS3Location) obj;
        return Objects.equals(bucketOwnerAccountId(), other.bucketOwnerAccountId()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomS3Location").add("BucketOwnerAccountId", bucketOwnerAccountId()).add("Uri", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketOwnerAccountId":
            return Optional.ofNullable(clazz.cast(bucketOwnerAccountId()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketOwnerAccountId", BUCKET_OWNER_ACCOUNT_ID_FIELD);
        map.put("uri", URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomS3Location, T> g) {
        return obj -> g.apply((CustomS3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomS3Location> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account that owns the S3 bucket containing the content to ingest.
         * </p>
         * 
         * @param bucketOwnerAccountId
         *        The identifier of the Amazon Web Services account that owns the S3 bucket containing the content to
         *        ingest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketOwnerAccountId(String bucketOwnerAccountId);

        /**
         * <p>
         * The S3 URI of the file containing the content to ingest.
         * </p>
         * 
         * @param uri
         *        The S3 URI of the file containing the content to ingest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String bucketOwnerAccountId;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomS3Location model) {
            bucketOwnerAccountId(model.bucketOwnerAccountId);
            uri(model.uri);
        }

        public final String getBucketOwnerAccountId() {
            return bucketOwnerAccountId;
        }

        public final void setBucketOwnerAccountId(String bucketOwnerAccountId) {
            this.bucketOwnerAccountId = bucketOwnerAccountId;
        }

        @Override
        public final Builder bucketOwnerAccountId(String bucketOwnerAccountId) {
            this.bucketOwnerAccountId = bucketOwnerAccountId;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public CustomS3Location build() {
            return new CustomS3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
