/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFlowRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<DeleteFlowRequest.Builder, DeleteFlowRequest> {
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(DeleteFlowRequest::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()).build();

    private static final SdkField<Boolean> SKIP_RESOURCE_IN_USE_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipResourceInUseCheck")
            .getter(getter(DeleteFlowRequest::skipResourceInUseCheck))
            .setter(setter(Builder::skipResourceInUseCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipResourceInUseCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_IDENTIFIER_FIELD,
            SKIP_RESOURCE_IN_USE_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flowIdentifier;

    private final Boolean skipResourceInUseCheck;

    private DeleteFlowRequest(BuilderImpl builder) {
        super(builder);
        this.flowIdentifier = builder.flowIdentifier;
        this.skipResourceInUseCheck = builder.skipResourceInUseCheck;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * <p>
     * By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it to
     * <code>true</code>, the resource will be deleted even if the resource is in use.
     * </p>
     * 
     * @return By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you
     *         set it to <code>true</code>, the resource will be deleted even if the resource is in use.
     */
    public final Boolean skipResourceInUseCheck() {
        return skipResourceInUseCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(skipResourceInUseCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowRequest)) {
            return false;
        }
        DeleteFlowRequest other = (DeleteFlowRequest) obj;
        return Objects.equals(flowIdentifier(), other.flowIdentifier())
                && Objects.equals(skipResourceInUseCheck(), other.skipResourceInUseCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFlowRequest").add("FlowIdentifier", flowIdentifier())
                .add("SkipResourceInUseCheck", skipResourceInUseCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "skipResourceInUseCheck":
            return Optional.ofNullable(clazz.cast(skipResourceInUseCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("skipResourceInUseCheck", SKIP_RESOURCE_IN_USE_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFlowRequest, T> g) {
        return obj -> g.apply((DeleteFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFlowRequest> {
        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you set it
         * to <code>true</code>, the resource will be deleted even if the resource is in use.
         * </p>
         * 
         * @param skipResourceInUseCheck
         *        By default, this value is <code>false</code> and deletion is stopped if the resource is in use. If you
         *        set it to <code>true</code>, the resource will be deleted even if the resource is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String flowIdentifier;

        private Boolean skipResourceInUseCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowRequest model) {
            super(model);
            flowIdentifier(model.flowIdentifier);
            skipResourceInUseCheck(model.skipResourceInUseCheck);
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final Boolean getSkipResourceInUseCheck() {
            return skipResourceInUseCheck;
        }

        public final void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
        }

        @Override
        public final Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowRequest build() {
            return new DeleteFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
