/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteKnowledgeBaseDocumentsRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<DeleteKnowledgeBaseDocumentsRequest.Builder, DeleteKnowledgeBaseDocumentsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteKnowledgeBaseDocumentsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(DeleteKnowledgeBaseDocumentsRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<List<DocumentIdentifier>> DOCUMENT_IDENTIFIERS_FIELD = SdkField
            .<List<DocumentIdentifier>> builder(MarshallingType.LIST)
            .memberName("documentIdentifiers")
            .getter(getter(DeleteKnowledgeBaseDocumentsRequest::documentIdentifiers))
            .setter(setter(Builder::documentIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(DeleteKnowledgeBaseDocumentsRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATA_SOURCE_ID_FIELD, DOCUMENT_IDENTIFIERS_FIELD, KNOWLEDGE_BASE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String dataSourceId;

    private final List<DocumentIdentifier> documentIdentifiers;

    private final String knowledgeBaseId;

    private DeleteKnowledgeBaseDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataSourceId = builder.dataSourceId;
        this.documentIdentifiers = builder.documentIdentifiers;
        this.knowledgeBaseId = builder.knowledgeBaseId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the data source that contains the documents.
     * </p>
     * 
     * @return The unique identifier of the data source that contains the documents.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentIdentifiers() {
        return documentIdentifiers != null && !(documentIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information to identify a document to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentIdentifiers} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information to identify a document to delete.
     */
    public final List<DocumentIdentifier> documentIdentifiers() {
        return documentIdentifiers;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base that is connected to the data source.
     * </p>
     * 
     * @return The unique identifier of the knowledge base that is connected to the data source.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentIdentifiers() ? documentIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKnowledgeBaseDocumentsRequest)) {
            return false;
        }
        DeleteKnowledgeBaseDocumentsRequest other = (DeleteKnowledgeBaseDocumentsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && hasDocumentIdentifiers() == other.hasDocumentIdentifiers()
                && Objects.equals(documentIdentifiers(), other.documentIdentifiers())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteKnowledgeBaseDocumentsRequest").add("ClientToken", clientToken())
                .add("DataSourceId", dataSourceId())
                .add("DocumentIdentifiers", hasDocumentIdentifiers() ? documentIdentifiers() : null)
                .add("KnowledgeBaseId", knowledgeBaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "documentIdentifiers":
            return Optional.ofNullable(clazz.cast(documentIdentifiers()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("documentIdentifiers", DOCUMENT_IDENTIFIERS_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteKnowledgeBaseDocumentsRequest, T> g) {
        return obj -> g.apply((DeleteKnowledgeBaseDocumentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteKnowledgeBaseDocumentsRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the data source that contains the documents.
         * </p>
         * 
         * @param dataSourceId
         *        The unique identifier of the data source that contains the documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A list of objects, each of which contains information to identify a document to delete.
         * </p>
         * 
         * @param documentIdentifiers
         *        A list of objects, each of which contains information to identify a document to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers);

        /**
         * <p>
         * A list of objects, each of which contains information to identify a document to delete.
         * </p>
         * 
         * @param documentIdentifiers
         *        A list of objects, each of which contains information to identify a document to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdentifiers(DocumentIdentifier... documentIdentifiers);

        /**
         * <p>
         * A list of objects, each of which contains information to identify a document to delete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.DocumentIdentifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.DocumentIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.DocumentIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #documentIdentifiers(List<DocumentIdentifier>)}.
         * 
         * @param documentIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.DocumentIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentIdentifiers(java.util.Collection<DocumentIdentifier>)
         */
        Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder>... documentIdentifiers);

        /**
         * <p>
         * The unique identifier of the knowledge base that is connected to the data source.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base that is connected to the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String dataSourceId;

        private List<DocumentIdentifier> documentIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String knowledgeBaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKnowledgeBaseDocumentsRequest model) {
            super(model);
            clientToken(model.clientToken);
            dataSourceId(model.dataSourceId);
            documentIdentifiers(model.documentIdentifiers);
            knowledgeBaseId(model.knowledgeBaseId);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final List<DocumentIdentifier.Builder> getDocumentIdentifiers() {
            List<DocumentIdentifier.Builder> result = DocumentIdentifiersCopier.copyToBuilder(this.documentIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentIdentifiers(Collection<DocumentIdentifier.BuilderImpl> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifiersCopier.copyFromBuilder(documentIdentifiers);
        }

        @Override
        public final Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifiersCopier.copy(documentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(DocumentIdentifier... documentIdentifiers) {
            documentIdentifiers(Arrays.asList(documentIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder>... documentIdentifiers) {
            documentIdentifiers(Stream.of(documentIdentifiers).map(c -> DocumentIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteKnowledgeBaseDocumentsRequest build() {
            return new DeleteKnowledgeBaseDocumentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
