/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information that identifies the document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentIdentifier.Builder, DocumentIdentifier> {
    private static final SdkField<CustomDocumentIdentifier> CUSTOM_FIELD = SdkField
            .<CustomDocumentIdentifier> builder(MarshallingType.SDK_POJO).memberName("custom")
            .getter(getter(DocumentIdentifier::custom)).setter(setter(Builder::custom))
            .constructor(CustomDocumentIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceType").getter(getter(DocumentIdentifier::dataSourceTypeAsString))
            .setter(setter(Builder::dataSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()).build();

    private static final SdkField<S3Location> S3_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(DocumentIdentifier::s3)).setter(setter(Builder::s3)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_FIELD,
            DATA_SOURCE_TYPE_FIELD, S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomDocumentIdentifier custom;

    private final String dataSourceType;

    private final S3Location s3;

    private DocumentIdentifier(BuilderImpl builder) {
        this.custom = builder.custom;
        this.dataSourceType = builder.dataSourceType;
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * Contains information that identifies the document in a custom data source.
     * </p>
     * 
     * @return Contains information that identifies the document in a custom data source.
     */
    public final CustomDocumentIdentifier custom() {
        return custom;
    }

    /**
     * <p>
     * The type of data source connected to the knowledge base that contains the document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link ContentDataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return The type of data source connected to the knowledge base that contains the document.
     * @see ContentDataSourceType
     */
    public final ContentDataSourceType dataSourceType() {
        return ContentDataSourceType.fromValue(dataSourceType);
    }

    /**
     * <p>
     * The type of data source connected to the knowledge base that contains the document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSourceType}
     * will return {@link ContentDataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dataSourceTypeAsString}.
     * </p>
     * 
     * @return The type of data source connected to the knowledge base that contains the document.
     * @see ContentDataSourceType
     */
    public final String dataSourceTypeAsString() {
        return dataSourceType;
    }

    /**
     * <p>
     * Contains information that identifies the document in an S3 data source.
     * </p>
     * 
     * @return Contains information that identifies the document in an S3 data source.
     */
    public final S3Location s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier) obj;
        return Objects.equals(custom(), other.custom())
                && Objects.equals(dataSourceTypeAsString(), other.dataSourceTypeAsString()) && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentIdentifier").add("Custom", custom()).add("DataSourceType", dataSourceTypeAsString())
                .add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        case "dataSourceType":
            return Optional.ofNullable(clazz.cast(dataSourceTypeAsString()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("custom", CUSTOM_FIELD);
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentIdentifier, T> g) {
        return obj -> g.apply((DocumentIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentIdentifier> {
        /**
         * <p>
         * Contains information that identifies the document in a custom data source.
         * </p>
         * 
         * @param custom
         *        Contains information that identifies the document in a custom data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(CustomDocumentIdentifier custom);

        /**
         * <p>
         * Contains information that identifies the document in a custom data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDocumentIdentifier.Builder}
         * avoiding the need to create one manually via {@link CustomDocumentIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDocumentIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #custom(CustomDocumentIdentifier)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link CustomDocumentIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(CustomDocumentIdentifier)
         */
        default Builder custom(Consumer<CustomDocumentIdentifier.Builder> custom) {
            return custom(CustomDocumentIdentifier.builder().applyMutation(custom).build());
        }

        /**
         * <p>
         * The type of data source connected to the knowledge base that contains the document.
         * </p>
         * 
         * @param dataSourceType
         *        The type of data source connected to the knowledge base that contains the document.
         * @see ContentDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentDataSourceType
         */
        Builder dataSourceType(String dataSourceType);

        /**
         * <p>
         * The type of data source connected to the knowledge base that contains the document.
         * </p>
         * 
         * @param dataSourceType
         *        The type of data source connected to the knowledge base that contains the document.
         * @see ContentDataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentDataSourceType
         */
        Builder dataSourceType(ContentDataSourceType dataSourceType);

        /**
         * <p>
         * Contains information that identifies the document in an S3 data source.
         * </p>
         * 
         * @param s3
         *        Contains information that identifies the document in an S3 data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Location s3);

        /**
         * <p>
         * Contains information that identifies the document in an S3 data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3(S3Location)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Location)
         */
        default Builder s3(Consumer<S3Location.Builder> s3) {
            return s3(S3Location.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomDocumentIdentifier custom;

        private String dataSourceType;

        private S3Location s3;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdentifier model) {
            custom(model.custom);
            dataSourceType(model.dataSourceType);
            s3(model.s3);
        }

        public final CustomDocumentIdentifier.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(CustomDocumentIdentifier.BuilderImpl custom) {
            this.custom = custom != null ? custom.build() : null;
        }

        @Override
        public final Builder custom(CustomDocumentIdentifier custom) {
            this.custom = custom;
            return this;
        }

        public final String getDataSourceType() {
            return dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(ContentDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final S3Location.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3Location.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3Location s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public DocumentIdentifier build() {
            return new DocumentIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
