/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about duplicate condition expressions found in a condition node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DuplicateConditionExpressionFlowValidationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<DuplicateConditionExpressionFlowValidationDetails.Builder, DuplicateConditionExpressionFlowValidationDetails> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(DuplicateConditionExpressionFlowValidationDetails::expression))
            .setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<String> NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("node")
            .getter(getter(DuplicateConditionExpressionFlowValidationDetails::node)).setter(setter(Builder::node))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("node").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, NODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final String node;

    private DuplicateConditionExpressionFlowValidationDetails(BuilderImpl builder) {
        this.expression = builder.expression;
        this.node = builder.node;
    }

    /**
     * <p>
     * The duplicated condition expression.
     * </p>
     * 
     * @return The duplicated condition expression.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The name of the node containing the duplicate condition expressions.
     * </p>
     * 
     * @return The name of the node containing the duplicate condition expressions.
     */
    public final String node() {
        return node;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(node());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DuplicateConditionExpressionFlowValidationDetails)) {
            return false;
        }
        DuplicateConditionExpressionFlowValidationDetails other = (DuplicateConditionExpressionFlowValidationDetails) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(node(), other.node());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DuplicateConditionExpressionFlowValidationDetails")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***").add("Node", node()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "node":
            return Optional.ofNullable(clazz.cast(node()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("node", NODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DuplicateConditionExpressionFlowValidationDetails, T> g) {
        return obj -> g.apply((DuplicateConditionExpressionFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DuplicateConditionExpressionFlowValidationDetails> {
        /**
         * <p>
         * The duplicated condition expression.
         * </p>
         * 
         * @param expression
         *        The duplicated condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The name of the node containing the duplicate condition expressions.
         * </p>
         * 
         * @param node
         *        The name of the node containing the duplicate condition expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder node(String node);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private String node;

        private BuilderImpl() {
        }

        private BuilderImpl(DuplicateConditionExpressionFlowValidationDetails model) {
            expression(model.expression);
            node(model.node);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNode() {
            return node;
        }

        public final void setNode(String node) {
            this.node = node;
        }

        @Override
        public final Builder node(String node) {
            this.node = node;
            return this;
        }

        @Override
        public DuplicateConditionExpressionFlowValidationDetails build() {
            return new DuplicateConditionExpressionFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
