/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a version that the alias maps to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowAliasRoutingConfigurationListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowAliasRoutingConfigurationListItem.Builder, FlowAliasRoutingConfigurationListItem> {
    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowVersion").getter(getter(FlowAliasRoutingConfigurationListItem::flowVersion))
            .setter(setter(Builder::flowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowVersion;

    private FlowAliasRoutingConfigurationListItem(BuilderImpl builder) {
        this.flowVersion = builder.flowVersion;
    }

    /**
     * <p>
     * The version that the alias maps to.
     * </p>
     * 
     * @return The version that the alias maps to.
     */
    public final String flowVersion() {
        return flowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowAliasRoutingConfigurationListItem)) {
            return false;
        }
        FlowAliasRoutingConfigurationListItem other = (FlowAliasRoutingConfigurationListItem) obj;
        return Objects.equals(flowVersion(), other.flowVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowAliasRoutingConfigurationListItem").add("FlowVersion", flowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowVersion":
            return Optional.ofNullable(clazz.cast(flowVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowVersion", FLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowAliasRoutingConfigurationListItem, T> g) {
        return obj -> g.apply((FlowAliasRoutingConfigurationListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowAliasRoutingConfigurationListItem> {
        /**
         * <p>
         * The version that the alias maps to.
         * </p>
         * 
         * @param flowVersion
         *        The version that the alias maps to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowVersion(String flowVersion);
    }

    static final class BuilderImpl implements Builder {
        private String flowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowAliasRoutingConfigurationListItem model) {
            flowVersion(model.flowVersion);
        }

        public final String getFlowVersion() {
            return flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        @Override
        public FlowAliasRoutingConfigurationListItem build() {
            return new FlowAliasRoutingConfigurationListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
