/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for an input to a node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowNodeInput implements SdkPojo, Serializable, ToCopyableBuilder<FlowNodeInput.Builder, FlowNodeInput> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(FlowNodeInput::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FlowNodeInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowNodeInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, NAME_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String expression;

    private final String name;

    private final String type;

    private FlowNodeInput(BuilderImpl builder) {
        this.expression = builder.expression;
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * An expression that formats the input for the node. For an explanation of how to create expressions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt flows in
     * Amazon Bedrock</a>.
     * </p>
     * 
     * @return An expression that formats the input for the node. For an explanation of how to create expressions, see
     *         <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in
     *         Prompt flows in Amazon Bedrock</a>.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A name for the input that you can reference.
     * </p>
     * 
     * @return A name for the input that you can reference.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the input. If the input doesn't match this type at runtime, a validation error will be thrown.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the input. If the input doesn't match this type at runtime, a validation error will be
     *         thrown.
     * @see FlowNodeIODataType
     */
    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the input. If the input doesn't match this type at runtime, a validation error will be thrown.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the input. If the input doesn't match this type at runtime, a validation error will be
     *         thrown.
     * @see FlowNodeIODataType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowNodeInput)) {
            return false;
        }
        FlowNodeInput other = (FlowNodeInput) obj;
        return Objects.equals(expression(), other.expression()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowNodeInput")
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***").add("Name", name())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowNodeInput, T> g) {
        return obj -> g.apply((FlowNodeInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowNodeInput> {
        /**
         * <p>
         * An expression that formats the input for the node. For an explanation of how to create expressions, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt
         * flows in Amazon Bedrock</a>.
         * </p>
         * 
         * @param expression
         *        An expression that formats the input for the node. For an explanation of how to create expressions,
         *        see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions
         *        in Prompt flows in Amazon Bedrock</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A name for the input that you can reference.
         * </p>
         * 
         * @param name
         *        A name for the input that you can reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the input. If the input doesn't match this type at runtime, a validation error will be
         * thrown.
         * </p>
         * 
         * @param type
         *        The data type of the input. If the input doesn't match this type at runtime, a validation error will
         *        be thrown.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the input. If the input doesn't match this type at runtime, a validation error will be
         * thrown.
         * </p>
         * 
         * @param type
         *        The data type of the input. If the input doesn't match this type at runtime, a validation error will
         *        be thrown.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(FlowNodeIODataType type);
    }

    static final class BuilderImpl implements Builder {
        private String expression;

        private String name;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowNodeInput model) {
            expression(model.expression);
            name(model.name);
            type(model.type);
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public FlowNodeInput build() {
            return new FlowNodeInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
