/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines functions that each define parameters that the agent needs to invoke from the user. Each function represents
 * an action in an action group.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax"
 * >CreateAgentActionGroup request</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax"
 * >CreateAgentActionGroup response</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax"
 * >UpdateAgentActionGroup request</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax"
 * >UpdateAgentActionGroup response</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax"
 * >GetAgentActionGroup response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionSchema implements SdkPojo, Serializable, ToCopyableBuilder<FunctionSchema.Builder, FunctionSchema> {
    private static final SdkField<List<Function>> FUNCTIONS_FIELD = SdkField
            .<List<Function>> builder(MarshallingType.LIST)
            .memberName("functions")
            .getter(getter(FunctionSchema::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Function> builder(MarshallingType.SDK_POJO)
                                            .constructor(Function::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Function> functions;

    private final Type type;

    private FunctionSchema(BuilderImpl builder) {
        this.functions = builder.functions;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of functions that each define an action in the action group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return A list of functions that each define an action in the action group.
     */
    public final List<Function> functions() {
        return functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionSchema)) {
            return false;
        }
        FunctionSchema other = (FunctionSchema) obj;
        return hasFunctions() == other.hasFunctions() && Objects.equals(functions(), other.functions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionSchema").add("Functions", hasFunctions() ? functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functions":
            return Optional.ofNullable(clazz.cast(functions()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #functions()} initialized to the given value.
     *
     * <p>
     * A list of functions that each define an action in the action group.
     * </p>
     * 
     * @param functions
     *        A list of functions that each define an action in the action group.
     */
    public static FunctionSchema fromFunctions(List<Function> functions) {
        return builder().functions(functions).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("functions", FUNCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> java.util.function.Function<Object, T> getter(java.util.function.Function<FunctionSchema, T> g) {
        return obj -> g.apply((FunctionSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionSchema> {
        /**
         * <p>
         * A list of functions that each define an action in the action group.
         * </p>
         * 
         * @param functions
         *        A list of functions that each define an action in the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Collection<Function> functions);

        /**
         * <p>
         * A list of functions that each define an action in the action group.
         * </p>
         * 
         * @param functions
         *        A list of functions that each define an action in the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Function... functions);

        /**
         * <p>
         * A list of functions that each define an action in the action group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.Function.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockagent.model.Function#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.Function.Builder#build()} is called immediately and
         * its result is passed to {@link #functions(List<Function>)}.
         * 
         * @param functions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.Function.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functions(java.util.Collection<Function>)
         */
        Builder functions(Consumer<Function.Builder>... functions);
    }

    static final class BuilderImpl implements Builder {
        private List<Function> functions = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionSchema model) {
            functions(model.functions);
        }

        public final List<Function.Builder> getFunctions() {
            List<Function.Builder> result = FunctionsCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Collection<Function.BuilderImpl> functions) {
            Object oldValue = this.functions;
            this.functions = FunctionsCopier.copyFromBuilder(functions);
            handleUnionValueChange(Type.FUNCTIONS, oldValue, this.functions);
        }

        @Override
        public final Builder functions(Collection<Function> functions) {
            Object oldValue = this.functions;
            this.functions = FunctionsCopier.copy(functions);
            handleUnionValueChange(Type.FUNCTIONS, oldValue, this.functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Function... functions) {
            functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<Function.Builder>... functions) {
            functions(Stream.of(functions).map(c -> Function.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FunctionSchema build() {
            return new FunctionSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FunctionSchema#type()
     */
    public enum Type {
        FUNCTIONS,

        UNKNOWN_TO_SDK_VERSION
    }
}
