/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for hierarchical document chunking for a data source. Hierarchical chunking splits documents into layers of
 * chunks where the first layer contains large chunks, and the second layer contains smaller chunks derived from the
 * first layer.
 * </p>
 * <p>
 * You configure the number of tokens to overlap, or repeat across adjacent chunks. For example, if you set overlap
 * tokens to 60, the last 60 tokens in the first chunk are also included at the beginning of the second chunk. For each
 * layer, you must also configure the maximum number of tokens in a chunk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchicalChunkingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HierarchicalChunkingConfiguration.Builder, HierarchicalChunkingConfiguration> {
    private static final SdkField<List<HierarchicalChunkingLevelConfiguration>> LEVEL_CONFIGURATIONS_FIELD = SdkField
            .<List<HierarchicalChunkingLevelConfiguration>> builder(MarshallingType.LIST)
            .memberName("levelConfigurations")
            .getter(getter(HierarchicalChunkingConfiguration::levelConfigurations))
            .setter(setter(Builder::levelConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("levelConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HierarchicalChunkingLevelConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HierarchicalChunkingLevelConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> OVERLAP_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("overlapTokens").getter(getter(HierarchicalChunkingConfiguration::overlapTokens))
            .setter(setter(Builder::overlapTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overlapTokens").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_CONFIGURATIONS_FIELD,
            OVERLAP_TOKENS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<HierarchicalChunkingLevelConfiguration> levelConfigurations;

    private final Integer overlapTokens;

    private HierarchicalChunkingConfiguration(BuilderImpl builder) {
        this.levelConfigurations = builder.levelConfigurations;
        this.overlapTokens = builder.overlapTokens;
    }

    /**
     * For responses, this returns true if the service returned a value for the LevelConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLevelConfigurations() {
        return levelConfigurations != null && !(levelConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Token settings for each layer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLevelConfigurations} method.
     * </p>
     * 
     * @return Token settings for each layer.
     */
    public final List<HierarchicalChunkingLevelConfiguration> levelConfigurations() {
        return levelConfigurations;
    }

    /**
     * <p>
     * The number of tokens to repeat across chunks in the same layer.
     * </p>
     * 
     * @return The number of tokens to repeat across chunks in the same layer.
     */
    public final Integer overlapTokens() {
        return overlapTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLevelConfigurations() ? levelConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overlapTokens());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchicalChunkingConfiguration)) {
            return false;
        }
        HierarchicalChunkingConfiguration other = (HierarchicalChunkingConfiguration) obj;
        return hasLevelConfigurations() == other.hasLevelConfigurations()
                && Objects.equals(levelConfigurations(), other.levelConfigurations())
                && Objects.equals(overlapTokens(), other.overlapTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchicalChunkingConfiguration")
                .add("LevelConfigurations", hasLevelConfigurations() ? levelConfigurations() : null)
                .add("OverlapTokens", overlapTokens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "levelConfigurations":
            return Optional.ofNullable(clazz.cast(levelConfigurations()));
        case "overlapTokens":
            return Optional.ofNullable(clazz.cast(overlapTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("levelConfigurations", LEVEL_CONFIGURATIONS_FIELD);
        map.put("overlapTokens", OVERLAP_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HierarchicalChunkingConfiguration, T> g) {
        return obj -> g.apply((HierarchicalChunkingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchicalChunkingConfiguration> {
        /**
         * <p>
         * Token settings for each layer.
         * </p>
         * 
         * @param levelConfigurations
         *        Token settings for each layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelConfigurations(Collection<HierarchicalChunkingLevelConfiguration> levelConfigurations);

        /**
         * <p>
         * Token settings for each layer.
         * </p>
         * 
         * @param levelConfigurations
         *        Token settings for each layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelConfigurations(HierarchicalChunkingLevelConfiguration... levelConfigurations);

        /**
         * <p>
         * Token settings for each layer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.HierarchicalChunkingLevelConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.HierarchicalChunkingLevelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.HierarchicalChunkingLevelConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #levelConfigurations(List<HierarchicalChunkingLevelConfiguration>)}.
         * 
         * @param levelConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.HierarchicalChunkingLevelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelConfigurations(java.util.Collection<HierarchicalChunkingLevelConfiguration>)
         */
        Builder levelConfigurations(Consumer<HierarchicalChunkingLevelConfiguration.Builder>... levelConfigurations);

        /**
         * <p>
         * The number of tokens to repeat across chunks in the same layer.
         * </p>
         * 
         * @param overlapTokens
         *        The number of tokens to repeat across chunks in the same layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overlapTokens(Integer overlapTokens);
    }

    static final class BuilderImpl implements Builder {
        private List<HierarchicalChunkingLevelConfiguration> levelConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Integer overlapTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchicalChunkingConfiguration model) {
            levelConfigurations(model.levelConfigurations);
            overlapTokens(model.overlapTokens);
        }

        public final List<HierarchicalChunkingLevelConfiguration.Builder> getLevelConfigurations() {
            List<HierarchicalChunkingLevelConfiguration.Builder> result = HierarchicalChunkingLevelConfigurationsCopier
                    .copyToBuilder(this.levelConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLevelConfigurations(
                Collection<HierarchicalChunkingLevelConfiguration.BuilderImpl> levelConfigurations) {
            this.levelConfigurations = HierarchicalChunkingLevelConfigurationsCopier.copyFromBuilder(levelConfigurations);
        }

        @Override
        public final Builder levelConfigurations(Collection<HierarchicalChunkingLevelConfiguration> levelConfigurations) {
            this.levelConfigurations = HierarchicalChunkingLevelConfigurationsCopier.copy(levelConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder levelConfigurations(HierarchicalChunkingLevelConfiguration... levelConfigurations) {
            levelConfigurations(Arrays.asList(levelConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder levelConfigurations(Consumer<HierarchicalChunkingLevelConfiguration.Builder>... levelConfigurations) {
            levelConfigurations(Stream.of(levelConfigurations)
                    .map(c -> HierarchicalChunkingLevelConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getOverlapTokens() {
            return overlapTokens;
        }

        public final void setOverlapTokens(Integer overlapTokens) {
            this.overlapTokens = overlapTokens;
        }

        @Override
        public final Builder overlapTokens(Integer overlapTokens) {
            this.overlapTokens = overlapTokens;
            return this;
        }

        @Override
        public HierarchicalChunkingConfiguration build() {
            return new HierarchicalChunkingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
