/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Instructions for interpreting the contents of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParsingPrompt implements SdkPojo, Serializable, ToCopyableBuilder<ParsingPrompt.Builder, ParsingPrompt> {
    private static final SdkField<String> PARSING_PROMPT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parsingPromptText").getter(getter(ParsingPrompt::parsingPromptText))
            .setter(setter(Builder::parsingPromptText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingPromptText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARSING_PROMPT_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parsingPromptText;

    private ParsingPrompt(BuilderImpl builder) {
        this.parsingPromptText = builder.parsingPromptText;
    }

    /**
     * <p>
     * Instructions for interpreting the contents of a document.
     * </p>
     * 
     * @return Instructions for interpreting the contents of a document.
     */
    public final String parsingPromptText() {
        return parsingPromptText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parsingPromptText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParsingPrompt)) {
            return false;
        }
        ParsingPrompt other = (ParsingPrompt) obj;
        return Objects.equals(parsingPromptText(), other.parsingPromptText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParsingPrompt").add("ParsingPromptText", parsingPromptText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parsingPromptText":
            return Optional.ofNullable(clazz.cast(parsingPromptText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("parsingPromptText", PARSING_PROMPT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParsingPrompt, T> g) {
        return obj -> g.apply((ParsingPrompt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParsingPrompt> {
        /**
         * <p>
         * Instructions for interpreting the contents of a document.
         * </p>
         * 
         * @param parsingPromptText
         *        Instructions for interpreting the contents of a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parsingPromptText(String parsingPromptText);
    }

    static final class BuilderImpl implements Builder {
        private String parsingPromptText;

        private BuilderImpl() {
        }

        private BuilderImpl(ParsingPrompt model) {
            parsingPromptText(model.parsingPromptText);
        }

        public final String getParsingPromptText() {
            return parsingPromptText;
        }

        public final void setParsingPromptText(String parsingPromptText) {
            this.parsingPromptText = parsingPromptText;
        }

        @Override
        public final Builder parsingPromptText(String parsingPromptText) {
            this.parsingPromptText = parsingPromptText;
            return this;
        }

        @Override
        public ParsingPrompt build() {
            return new ParsingPrompt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
