/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specific filters applied to your data source content. You can filter out or include certain content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatternObjectFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<PatternObjectFilter.Builder, PatternObjectFilter> {
    private static final SdkField<List<String>> EXCLUSION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exclusionFilters")
            .getter(getter(PatternObjectFilter::exclusionFilters))
            .setter(setter(Builder::exclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUSION_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inclusionFilters")
            .getter(getter(PatternObjectFilter::inclusionFilters))
            .setter(setter(Builder::inclusionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("objectType").getter(getter(PatternObjectFilter::objectType)).setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_FILTERS_FIELD,
            INCLUSION_FILTERS_FIELD, OBJECT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> exclusionFilters;

    private final List<String> inclusionFilters;

    private final String objectType;

    private PatternObjectFilter(BuilderImpl builder) {
        this.exclusionFilters = builder.exclusionFilters;
        this.inclusionFilters = builder.inclusionFilters;
        this.objectType = builder.objectType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExclusionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExclusionFilters() {
        return exclusionFilters != null && !(exclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more exclusion regular expression patterns to exclude certain object types that adhere to the
     * pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter
     * takes precedence and the document isn’t crawled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExclusionFilters} method.
     * </p>
     * 
     * @return A list of one or more exclusion regular expression patterns to exclude certain object types that adhere
     *         to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the
     *         exclusion filter takes precedence and the document isn’t crawled.
     */
    public final List<String> exclusionFilters() {
        return exclusionFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InclusionFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInclusionFilters() {
        return inclusionFilters != null && !(inclusionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more inclusion regular expression patterns to include certain object types that adhere to the
     * pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the exclusion filter
     * takes precedence and the document isn’t crawled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclusionFilters} method.
     * </p>
     * 
     * @return A list of one or more inclusion regular expression patterns to include certain object types that adhere
     *         to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the
     *         exclusion filter takes precedence and the document isn’t crawled.
     */
    public final List<String> inclusionFilters() {
        return inclusionFilters;
    }

    /**
     * <p>
     * The supported object type or content type of the data source.
     * </p>
     * 
     * @return The supported object type or content type of the data source.
     */
    public final String objectType() {
        return objectType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExclusionFilters() ? exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclusionFilters() ? inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(objectType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternObjectFilter)) {
            return false;
        }
        PatternObjectFilter other = (PatternObjectFilter) obj;
        return hasExclusionFilters() == other.hasExclusionFilters()
                && Objects.equals(exclusionFilters(), other.exclusionFilters())
                && hasInclusionFilters() == other.hasInclusionFilters()
                && Objects.equals(inclusionFilters(), other.inclusionFilters())
                && Objects.equals(objectType(), other.objectType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PatternObjectFilter")
                .add("ExclusionFilters", exclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InclusionFilters", inclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ObjectType", objectType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exclusionFilters":
            return Optional.ofNullable(clazz.cast(exclusionFilters()));
        case "inclusionFilters":
            return Optional.ofNullable(clazz.cast(inclusionFilters()));
        case "objectType":
            return Optional.ofNullable(clazz.cast(objectType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("inclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("objectType", OBJECT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PatternObjectFilter, T> g) {
        return obj -> g.apply((PatternObjectFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatternObjectFilter> {
        /**
         * <p>
         * A list of one or more exclusion regular expression patterns to exclude certain object types that adhere to
         * the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the
         * exclusion filter takes precedence and the document isn’t crawled.
         * </p>
         * 
         * @param exclusionFilters
         *        A list of one or more exclusion regular expression patterns to exclude certain object types that
         *        adhere to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a
         *        document, the exclusion filter takes precedence and the document isn’t crawled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFilters(Collection<String> exclusionFilters);

        /**
         * <p>
         * A list of one or more exclusion regular expression patterns to exclude certain object types that adhere to
         * the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the
         * exclusion filter takes precedence and the document isn’t crawled.
         * </p>
         * 
         * @param exclusionFilters
         *        A list of one or more exclusion regular expression patterns to exclude certain object types that
         *        adhere to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a
         *        document, the exclusion filter takes precedence and the document isn’t crawled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusionFilters(String... exclusionFilters);

        /**
         * <p>
         * A list of one or more inclusion regular expression patterns to include certain object types that adhere to
         * the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the
         * exclusion filter takes precedence and the document isn’t crawled.
         * </p>
         * 
         * @param inclusionFilters
         *        A list of one or more inclusion regular expression patterns to include certain object types that
         *        adhere to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a
         *        document, the exclusion filter takes precedence and the document isn’t crawled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(Collection<String> inclusionFilters);

        /**
         * <p>
         * A list of one or more inclusion regular expression patterns to include certain object types that adhere to
         * the pattern. If you specify an inclusion and exclusion filter/pattern and both match a document, the
         * exclusion filter takes precedence and the document isn’t crawled.
         * </p>
         * 
         * @param inclusionFilters
         *        A list of one or more inclusion regular expression patterns to include certain object types that
         *        adhere to the pattern. If you specify an inclusion and exclusion filter/pattern and both match a
         *        document, the exclusion filter takes precedence and the document isn’t crawled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionFilters(String... inclusionFilters);

        /**
         * <p>
         * The supported object type or content type of the data source.
         * </p>
         * 
         * @param objectType
         *        The supported object type or content type of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectType(String objectType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> exclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> inclusionFilters = DefaultSdkAutoConstructList.getInstance();

        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(PatternObjectFilter model) {
            exclusionFilters(model.exclusionFilters);
            inclusionFilters(model.inclusionFilters);
            objectType(model.objectType);
        }

        public final Collection<String> getExclusionFilters() {
            if (exclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return exclusionFilters;
        }

        public final void setExclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(String... exclusionFilters) {
            exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        public final Collection<String> getInclusionFilters() {
            if (inclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return inclusionFilters;
        }

        public final void setInclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(String... inclusionFilters) {
            inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        public final String getObjectType() {
            return objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public PatternObjectFilter build() {
            return new PatternObjectFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
