/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the storage configuration of the knowledge base in Pinecone. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html">Create a vector index
 * in Pinecone</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PineconeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PineconeConfiguration.Builder, PineconeConfiguration> {
    private static final SdkField<String> CONNECTION_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionString").getter(getter(PineconeConfiguration::connectionString))
            .setter(setter(Builder::connectionString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionString").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(PineconeConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<PineconeFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<PineconeFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(PineconeConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(PineconeFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(PineconeConfiguration::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STRING_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD, FIELD_MAPPING_FIELD, NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionString;

    private final String credentialsSecretArn;

    private final PineconeFieldMapping fieldMapping;

    private final String namespace;

    private PineconeConfiguration(BuilderImpl builder) {
        this.connectionString = builder.connectionString;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.fieldMapping = builder.fieldMapping;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The endpoint URL for your index management page.
     * </p>
     * 
     * @return The endpoint URL for your index management page.
     */
    public final String connectionString() {
        return connectionString;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your Pinecone
     * API key.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your
     *         Pinecone API key.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final PineconeFieldMapping fieldMapping() {
        return fieldMapping;
    }

    /**
     * <p>
     * The namespace to be used to write new data to your database.
     * </p>
     * 
     * @return The namespace to be used to write new data to your database.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PineconeConfiguration)) {
            return false;
        }
        PineconeConfiguration other = (PineconeConfiguration) obj;
        return Objects.equals(connectionString(), other.connectionString())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(fieldMapping(), other.fieldMapping()) && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PineconeConfiguration").add("ConnectionString", connectionString())
                .add("CredentialsSecretArn", credentialsSecretArn()).add("FieldMapping", fieldMapping())
                .add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionString":
            return Optional.ofNullable(clazz.cast(connectionString()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectionString", CONNECTION_STRING_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PineconeConfiguration, T> g) {
        return obj -> g.apply((PineconeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PineconeConfiguration> {
        /**
         * <p>
         * The endpoint URL for your index management page.
         * </p>
         * 
         * @param connectionString
         *        The endpoint URL for your index management page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionString(String connectionString);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to your
         * Pinecone API key.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that is linked to
         *        your Pinecone API key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(PineconeFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the {@link PineconeFieldMapping.Builder} avoiding
         * the need to create one manually via {@link PineconeFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PineconeFieldMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldMapping(PineconeFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link PineconeFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(PineconeFieldMapping)
         */
        default Builder fieldMapping(Consumer<PineconeFieldMapping.Builder> fieldMapping) {
            return fieldMapping(PineconeFieldMapping.builder().applyMutation(fieldMapping).build());
        }

        /**
         * <p>
         * The namespace to be used to write new data to your database.
         * </p>
         * 
         * @param namespace
         *        The namespace to be used to write new data to your database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String connectionString;

        private String credentialsSecretArn;

        private PineconeFieldMapping fieldMapping;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(PineconeConfiguration model) {
            connectionString(model.connectionString);
            credentialsSecretArn(model.credentialsSecretArn);
            fieldMapping(model.fieldMapping);
            namespace(model.namespace);
        }

        public final String getConnectionString() {
            return connectionString;
        }

        public final void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        @Override
        public final Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final PineconeFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(PineconeFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(PineconeFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public PineconeConfiguration build() {
            return new PineconeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
