/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the message for a prompt. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Construct and store reusable
 * prompts with Prompt management in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptTemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptTemplateConfiguration.Builder, PromptTemplateConfiguration> {
    private static final SdkField<ChatPromptTemplateConfiguration> CHAT_FIELD = SdkField
            .<ChatPromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("chat")
            .getter(getter(PromptTemplateConfiguration::chat)).setter(setter(Builder::chat))
            .constructor(ChatPromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chat").build()).build();

    private static final SdkField<TextPromptTemplateConfiguration> TEXT_FIELD = SdkField
            .<TextPromptTemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("text")
            .getter(getter(PromptTemplateConfiguration::text)).setter(setter(Builder::text))
            .constructor(TextPromptTemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAT_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ChatPromptTemplateConfiguration chat;

    private final TextPromptTemplateConfiguration text;

    private final Type type;

    private PromptTemplateConfiguration(BuilderImpl builder) {
        this.chat = builder.chat;
        this.text = builder.text;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configurations to use the prompt in a conversational format.
     * </p>
     * 
     * @return Contains configurations to use the prompt in a conversational format.
     */
    public final ChatPromptTemplateConfiguration chat() {
        return chat;
    }

    /**
     * <p>
     * Contains configurations for the text in a message for a prompt.
     * </p>
     * 
     * @return Contains configurations for the text in a message for a prompt.
     */
    public final TextPromptTemplateConfiguration text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chat());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptTemplateConfiguration)) {
            return false;
        }
        PromptTemplateConfiguration other = (PromptTemplateConfiguration) obj;
        return Objects.equals(chat(), other.chat()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptTemplateConfiguration")
                .add("Chat", chat() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "chat":
            return Optional.ofNullable(clazz.cast(chat()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #chat()} initialized to the given value.
     *
     * <p>
     * Contains configurations to use the prompt in a conversational format.
     * </p>
     * 
     * @param chat
     *        Contains configurations to use the prompt in a conversational format.
     */
    public static PromptTemplateConfiguration fromChat(ChatPromptTemplateConfiguration chat) {
        return builder().chat(chat).build();
    }

    /**
     * Create an instance of this class with {@link #chat()} initialized to the given value.
     *
     * <p>
     * Contains configurations to use the prompt in a conversational format.
     * </p>
     * 
     * @param chat
     *        Contains configurations to use the prompt in a conversational format.
     */
    public static PromptTemplateConfiguration fromChat(Consumer<ChatPromptTemplateConfiguration.Builder> chat) {
        ChatPromptTemplateConfiguration.Builder builder = ChatPromptTemplateConfiguration.builder();
        chat.accept(builder);
        return fromChat(builder.build());
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Contains configurations for the text in a message for a prompt.
     * </p>
     * 
     * @param text
     *        Contains configurations for the text in a message for a prompt.
     */
    public static PromptTemplateConfiguration fromText(TextPromptTemplateConfiguration text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Contains configurations for the text in a message for a prompt.
     * </p>
     * 
     * @param text
     *        Contains configurations for the text in a message for a prompt.
     */
    public static PromptTemplateConfiguration fromText(Consumer<TextPromptTemplateConfiguration.Builder> text) {
        TextPromptTemplateConfiguration.Builder builder = TextPromptTemplateConfiguration.builder();
        text.accept(builder);
        return fromText(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("chat", CHAT_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptTemplateConfiguration, T> g) {
        return obj -> g.apply((PromptTemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptTemplateConfiguration> {
        /**
         * <p>
         * Contains configurations to use the prompt in a conversational format.
         * </p>
         * 
         * @param chat
         *        Contains configurations to use the prompt in a conversational format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chat(ChatPromptTemplateConfiguration chat);

        /**
         * <p>
         * Contains configurations to use the prompt in a conversational format.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatPromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChatPromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatPromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #chat(ChatPromptTemplateConfiguration)}.
         * 
         * @param chat
         *        a consumer that will call methods on {@link ChatPromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chat(ChatPromptTemplateConfiguration)
         */
        default Builder chat(Consumer<ChatPromptTemplateConfiguration.Builder> chat) {
            return chat(ChatPromptTemplateConfiguration.builder().applyMutation(chat).build());
        }

        /**
         * <p>
         * Contains configurations for the text in a message for a prompt.
         * </p>
         * 
         * @param text
         *        Contains configurations for the text in a message for a prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(TextPromptTemplateConfiguration text);

        /**
         * <p>
         * Contains configurations for the text in a message for a prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextPromptTemplateConfiguration.Builder}
         * avoiding the need to create one manually via {@link TextPromptTemplateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextPromptTemplateConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #text(TextPromptTemplateConfiguration)}.
         * 
         * @param text
         *        a consumer that will call methods on {@link TextPromptTemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #text(TextPromptTemplateConfiguration)
         */
        default Builder text(Consumer<TextPromptTemplateConfiguration.Builder> text) {
            return text(TextPromptTemplateConfiguration.builder().applyMutation(text).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChatPromptTemplateConfiguration chat;

        private TextPromptTemplateConfiguration text;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PromptTemplateConfiguration model) {
            chat(model.chat);
            text(model.text);
        }

        public final ChatPromptTemplateConfiguration.Builder getChat() {
            return chat != null ? chat.toBuilder() : null;
        }

        public final void setChat(ChatPromptTemplateConfiguration.BuilderImpl chat) {
            Object oldValue = this.chat;
            this.chat = chat != null ? chat.build() : null;
            handleUnionValueChange(Type.CHAT, oldValue, this.chat);
        }

        @Override
        public final Builder chat(ChatPromptTemplateConfiguration chat) {
            Object oldValue = this.chat;
            this.chat = chat;
            handleUnionValueChange(Type.CHAT, oldValue, this.chat);
            return this;
        }

        public final TextPromptTemplateConfiguration.Builder getText() {
            return text != null ? text.toBuilder() : null;
        }

        public final void setText(TextPromptTemplateConfiguration.BuilderImpl text) {
            Object oldValue = this.text;
            this.text = text != null ? text.build() : null;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(TextPromptTemplateConfiguration text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        @Override
        public PromptTemplateConfiguration build() {
            return new PromptTemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PromptTemplateConfiguration#type()
     */
    public enum Type {
        CHAT,

        TEXT,

        UNKNOWN_TO_SDK_VERSION
    }
}
