/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for query generation. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge
 * base by connecting to a structured data source</a> in the Amazon Bedrock User Guide..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryGenerationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryGenerationConfiguration.Builder, QueryGenerationConfiguration> {
    private static final SdkField<Integer> EXECUTION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("executionTimeoutSeconds").getter(getter(QueryGenerationConfiguration::executionTimeoutSeconds))
            .setter(setter(Builder::executionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutSeconds").build())
            .build();

    private static final SdkField<QueryGenerationContext> GENERATION_CONTEXT_FIELD = SdkField
            .<QueryGenerationContext> builder(MarshallingType.SDK_POJO).memberName("generationContext")
            .getter(getter(QueryGenerationConfiguration::generationContext)).setter(setter(Builder::generationContext))
            .constructor(QueryGenerationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXECUTION_TIMEOUT_SECONDS_FIELD, GENERATION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer executionTimeoutSeconds;

    private final QueryGenerationContext generationContext;

    private QueryGenerationConfiguration(BuilderImpl builder) {
        this.executionTimeoutSeconds = builder.executionTimeoutSeconds;
        this.generationContext = builder.generationContext;
    }

    /**
     * <p>
     * The time after which query generation will time out.
     * </p>
     * 
     * @return The time after which query generation will time out.
     */
    public final Integer executionTimeoutSeconds() {
        return executionTimeoutSeconds;
    }

    /**
     * <p>
     * Specifies configurations for context to use during query generation.
     * </p>
     * 
     * @return Specifies configurations for context to use during query generation.
     */
    public final QueryGenerationContext generationContext() {
        return generationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(generationContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryGenerationConfiguration)) {
            return false;
        }
        QueryGenerationConfiguration other = (QueryGenerationConfiguration) obj;
        return Objects.equals(executionTimeoutSeconds(), other.executionTimeoutSeconds())
                && Objects.equals(generationContext(), other.generationContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryGenerationConfiguration").add("ExecutionTimeoutSeconds", executionTimeoutSeconds())
                .add("GenerationContext", generationContext() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(executionTimeoutSeconds()));
        case "generationContext":
            return Optional.ofNullable(clazz.cast(generationContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionTimeoutSeconds", EXECUTION_TIMEOUT_SECONDS_FIELD);
        map.put("generationContext", GENERATION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryGenerationConfiguration, T> g) {
        return obj -> g.apply((QueryGenerationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryGenerationConfiguration> {
        /**
         * <p>
         * The time after which query generation will time out.
         * </p>
         * 
         * @param executionTimeoutSeconds
         *        The time after which query generation will time out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeoutSeconds(Integer executionTimeoutSeconds);

        /**
         * <p>
         * Specifies configurations for context to use during query generation.
         * </p>
         * 
         * @param generationContext
         *        Specifies configurations for context to use during query generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationContext(QueryGenerationContext generationContext);

        /**
         * <p>
         * Specifies configurations for context to use during query generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryGenerationContext.Builder} avoiding
         * the need to create one manually via {@link QueryGenerationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryGenerationContext.Builder#build()} is called immediately and
         * its result is passed to {@link #generationContext(QueryGenerationContext)}.
         * 
         * @param generationContext
         *        a consumer that will call methods on {@link QueryGenerationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationContext(QueryGenerationContext)
         */
        default Builder generationContext(Consumer<QueryGenerationContext.Builder> generationContext) {
            return generationContext(QueryGenerationContext.builder().applyMutation(generationContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer executionTimeoutSeconds;

        private QueryGenerationContext generationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryGenerationConfiguration model) {
            executionTimeoutSeconds(model.executionTimeoutSeconds);
            generationContext(model.generationContext);
        }

        public final Integer getExecutionTimeoutSeconds() {
            return executionTimeoutSeconds;
        }

        public final void setExecutionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
        }

        @Override
        public final Builder executionTimeoutSeconds(Integer executionTimeoutSeconds) {
            this.executionTimeoutSeconds = executionTimeoutSeconds;
            return this;
        }

        public final QueryGenerationContext.Builder getGenerationContext() {
            return generationContext != null ? generationContext.toBuilder() : null;
        }

        public final void setGenerationContext(QueryGenerationContext.BuilderImpl generationContext) {
            this.generationContext = generationContext != null ? generationContext.build() : null;
        }

        @Override
        public final Builder generationContext(QueryGenerationContext generationContext) {
            this.generationContext = generationContext;
            return this;
        }

        @Override
        public QueryGenerationConfiguration build() {
            return new QueryGenerationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
