/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for authentication to an Amazon Redshift provisioned data warehouse. Specify the type of
 * authentication to use in the <code>type</code> field and include the corresponding field. If you specify IAM
 * authentication, you don't need to include another field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftProvisionedAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftProvisionedAuthConfiguration.Builder, RedshiftProvisionedAuthConfiguration> {
    private static final SdkField<String> DATABASE_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseUser").getter(getter(RedshiftProvisionedAuthConfiguration::databaseUser))
            .setter(setter(Builder::databaseUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseUser").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RedshiftProvisionedAuthConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> USERNAME_PASSWORD_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usernamePasswordSecretArn")
            .getter(getter(RedshiftProvisionedAuthConfiguration::usernamePasswordSecretArn))
            .setter(setter(Builder::usernamePasswordSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePasswordSecretArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_USER_FIELD,
            TYPE_FIELD, USERNAME_PASSWORD_SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String databaseUser;

    private final String type;

    private final String usernamePasswordSecretArn;

    private RedshiftProvisionedAuthConfiguration(BuilderImpl builder) {
        this.databaseUser = builder.databaseUser;
        this.type = builder.type;
        this.usernamePasswordSecretArn = builder.usernamePasswordSecretArn;
    }

    /**
     * <p>
     * The database username for authentication to an Amazon Redshift provisioned data warehouse.
     * </p>
     * 
     * @return The database username for authentication to an Amazon Redshift provisioned data warehouse.
     */
    public final String databaseUser() {
        return databaseUser;
    }

    /**
     * <p>
     * The type of authentication to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RedshiftProvisionedAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of authentication to use.
     * @see RedshiftProvisionedAuthType
     */
    public final RedshiftProvisionedAuthType type() {
        return RedshiftProvisionedAuthType.fromValue(type);
    }

    /**
     * <p>
     * The type of authentication to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RedshiftProvisionedAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of authentication to use.
     * @see RedshiftProvisionedAuthType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ARN of an Secrets Manager secret for authentication.
     * </p>
     * 
     * @return The ARN of an Secrets Manager secret for authentication.
     */
    public final String usernamePasswordSecretArn() {
        return usernamePasswordSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseUser());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usernamePasswordSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftProvisionedAuthConfiguration)) {
            return false;
        }
        RedshiftProvisionedAuthConfiguration other = (RedshiftProvisionedAuthConfiguration) obj;
        return Objects.equals(databaseUser(), other.databaseUser()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(usernamePasswordSecretArn(), other.usernamePasswordSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftProvisionedAuthConfiguration").add("DatabaseUser", databaseUser())
                .add("Type", typeAsString()).add("UsernamePasswordSecretArn", usernamePasswordSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseUser":
            return Optional.ofNullable(clazz.cast(databaseUser()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "usernamePasswordSecretArn":
            return Optional.ofNullable(clazz.cast(usernamePasswordSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("databaseUser", DATABASE_USER_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("usernamePasswordSecretArn", USERNAME_PASSWORD_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftProvisionedAuthConfiguration, T> g) {
        return obj -> g.apply((RedshiftProvisionedAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftProvisionedAuthConfiguration> {
        /**
         * <p>
         * The database username for authentication to an Amazon Redshift provisioned data warehouse.
         * </p>
         * 
         * @param databaseUser
         *        The database username for authentication to an Amazon Redshift provisioned data warehouse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseUser(String databaseUser);

        /**
         * <p>
         * The type of authentication to use.
         * </p>
         * 
         * @param type
         *        The type of authentication to use.
         * @see RedshiftProvisionedAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftProvisionedAuthType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of authentication to use.
         * </p>
         * 
         * @param type
         *        The type of authentication to use.
         * @see RedshiftProvisionedAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftProvisionedAuthType
         */
        Builder type(RedshiftProvisionedAuthType type);

        /**
         * <p>
         * The ARN of an Secrets Manager secret for authentication.
         * </p>
         * 
         * @param usernamePasswordSecretArn
         *        The ARN of an Secrets Manager secret for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernamePasswordSecretArn(String usernamePasswordSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String databaseUser;

        private String type;

        private String usernamePasswordSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftProvisionedAuthConfiguration model) {
            databaseUser(model.databaseUser);
            type(model.type);
            usernamePasswordSecretArn(model.usernamePasswordSecretArn);
        }

        public final String getDatabaseUser() {
            return databaseUser;
        }

        public final void setDatabaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
        }

        @Override
        public final Builder databaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RedshiftProvisionedAuthType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUsernamePasswordSecretArn() {
            return usernamePasswordSecretArn;
        }

        public final void setUsernamePasswordSecretArn(String usernamePasswordSecretArn) {
            this.usernamePasswordSecretArn = usernamePasswordSecretArn;
        }

        @Override
        public final Builder usernamePasswordSecretArn(String usernamePasswordSecretArn) {
            this.usernamePasswordSecretArn = usernamePasswordSecretArn;
            return this;
        }

        @Override
        public RedshiftProvisionedAuthConfiguration build() {
            return new RedshiftProvisionedAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
