/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a provisioned Amazon Redshift query engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftProvisionedConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftProvisionedConfiguration.Builder, RedshiftProvisionedConfiguration> {
    private static final SdkField<RedshiftProvisionedAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField
            .<RedshiftProvisionedAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("authConfiguration")
            .getter(getter(RedshiftProvisionedConfiguration::authConfiguration)).setter(setter(Builder::authConfiguration))
            .constructor(RedshiftProvisionedAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterIdentifier").getter(getter(RedshiftProvisionedConfiguration::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CONFIGURATION_FIELD,
            CLUSTER_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftProvisionedAuthConfiguration authConfiguration;

    private final String clusterIdentifier;

    private RedshiftProvisionedConfiguration(BuilderImpl builder) {
        this.authConfiguration = builder.authConfiguration;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    /**
     * <p>
     * Specifies configurations for authentication to Amazon Redshift.
     * </p>
     * 
     * @return Specifies configurations for authentication to Amazon Redshift.
     */
    public final RedshiftProvisionedAuthConfiguration authConfiguration() {
        return authConfiguration;
    }

    /**
     * <p>
     * The ID of the Amazon Redshift cluster.
     * </p>
     * 
     * @return The ID of the Amazon Redshift cluster.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftProvisionedConfiguration)) {
            return false;
        }
        RedshiftProvisionedConfiguration other = (RedshiftProvisionedConfiguration) obj;
        return Objects.equals(authConfiguration(), other.authConfiguration())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftProvisionedConfiguration").add("AuthConfiguration", authConfiguration())
                .add("ClusterIdentifier", clusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authConfiguration":
            return Optional.ofNullable(clazz.cast(authConfiguration()));
        case "clusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        map.put("clusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftProvisionedConfiguration, T> g) {
        return obj -> g.apply((RedshiftProvisionedConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftProvisionedConfiguration> {
        /**
         * <p>
         * Specifies configurations for authentication to Amazon Redshift.
         * </p>
         * 
         * @param authConfiguration
         *        Specifies configurations for authentication to Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfiguration(RedshiftProvisionedAuthConfiguration authConfiguration);

        /**
         * <p>
         * Specifies configurations for authentication to Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftProvisionedAuthConfiguration.Builder} avoiding the need to create one manually via
         * {@link RedshiftProvisionedAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftProvisionedAuthConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authConfiguration(RedshiftProvisionedAuthConfiguration)}.
         * 
         * @param authConfiguration
         *        a consumer that will call methods on {@link RedshiftProvisionedAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfiguration(RedshiftProvisionedAuthConfiguration)
         */
        default Builder authConfiguration(Consumer<RedshiftProvisionedAuthConfiguration.Builder> authConfiguration) {
            return authConfiguration(RedshiftProvisionedAuthConfiguration.builder().applyMutation(authConfiguration).build());
        }

        /**
         * <p>
         * The ID of the Amazon Redshift cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        The ID of the Amazon Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private RedshiftProvisionedAuthConfiguration authConfiguration;

        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftProvisionedConfiguration model) {
            authConfiguration(model.authConfiguration);
            clusterIdentifier(model.clusterIdentifier);
        }

        public final RedshiftProvisionedAuthConfiguration.Builder getAuthConfiguration() {
            return authConfiguration != null ? authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(RedshiftProvisionedAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(RedshiftProvisionedAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        @Override
        public RedshiftProvisionedConfiguration build() {
            return new RedshiftProvisionedConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
