/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for Amazon Redshift data storage. Specify the data storage service to use in the
 * <code>type</code> field and include the corresponding field. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge
 * base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftQueryEngineStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftQueryEngineStorageConfiguration.Builder, RedshiftQueryEngineStorageConfiguration> {
    private static final SdkField<RedshiftQueryEngineAwsDataCatalogStorageConfiguration> AWS_DATA_CATALOG_CONFIGURATION_FIELD = SdkField
            .<RedshiftQueryEngineAwsDataCatalogStorageConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("awsDataCatalogConfiguration")
            .getter(getter(RedshiftQueryEngineStorageConfiguration::awsDataCatalogConfiguration))
            .setter(setter(Builder::awsDataCatalogConfiguration))
            .constructor(RedshiftQueryEngineAwsDataCatalogStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDataCatalogConfiguration")
                    .build()).build();

    private static final SdkField<RedshiftQueryEngineRedshiftStorageConfiguration> REDSHIFT_CONFIGURATION_FIELD = SdkField
            .<RedshiftQueryEngineRedshiftStorageConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("redshiftConfiguration").getter(getter(RedshiftQueryEngineStorageConfiguration::redshiftConfiguration))
            .setter(setter(Builder::redshiftConfiguration)).constructor(RedshiftQueryEngineRedshiftStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftConfiguration").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RedshiftQueryEngineStorageConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_DATA_CATALOG_CONFIGURATION_FIELD, REDSHIFT_CONFIGURATION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration;

    private final RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration;

    private final String type;

    private RedshiftQueryEngineStorageConfiguration(BuilderImpl builder) {
        this.awsDataCatalogConfiguration = builder.awsDataCatalogConfiguration;
        this.redshiftConfiguration = builder.redshiftConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies configurations for storage in Glue Data Catalog.
     * </p>
     * 
     * @return Specifies configurations for storage in Glue Data Catalog.
     */
    public final RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration() {
        return awsDataCatalogConfiguration;
    }

    /**
     * <p>
     * Specifies configurations for storage in Amazon Redshift.
     * </p>
     * 
     * @return Specifies configurations for storage in Amazon Redshift.
     */
    public final RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration() {
        return redshiftConfiguration;
    }

    /**
     * <p>
     * The data storage service to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RedshiftQueryEngineStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The data storage service to use.
     * @see RedshiftQueryEngineStorageType
     */
    public final RedshiftQueryEngineStorageType type() {
        return RedshiftQueryEngineStorageType.fromValue(type);
    }

    /**
     * <p>
     * The data storage service to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RedshiftQueryEngineStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The data storage service to use.
     * @see RedshiftQueryEngineStorageType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsDataCatalogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftQueryEngineStorageConfiguration)) {
            return false;
        }
        RedshiftQueryEngineStorageConfiguration other = (RedshiftQueryEngineStorageConfiguration) obj;
        return Objects.equals(awsDataCatalogConfiguration(), other.awsDataCatalogConfiguration())
                && Objects.equals(redshiftConfiguration(), other.redshiftConfiguration())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftQueryEngineStorageConfiguration")
                .add("AwsDataCatalogConfiguration", awsDataCatalogConfiguration())
                .add("RedshiftConfiguration", redshiftConfiguration()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsDataCatalogConfiguration":
            return Optional.ofNullable(clazz.cast(awsDataCatalogConfiguration()));
        case "redshiftConfiguration":
            return Optional.ofNullable(clazz.cast(redshiftConfiguration()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsDataCatalogConfiguration", AWS_DATA_CATALOG_CONFIGURATION_FIELD);
        map.put("redshiftConfiguration", REDSHIFT_CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftQueryEngineStorageConfiguration, T> g) {
        return obj -> g.apply((RedshiftQueryEngineStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftQueryEngineStorageConfiguration> {
        /**
         * <p>
         * Specifies configurations for storage in Glue Data Catalog.
         * </p>
         * 
         * @param awsDataCatalogConfiguration
         *        Specifies configurations for storage in Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration);

        /**
         * <p>
         * Specifies configurations for storage in Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder} avoiding the need to create one
         * manually via {@link RedshiftQueryEngineAwsDataCatalogStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration)}.
         * 
         * @param awsDataCatalogConfiguration
         *        a consumer that will call methods on
         *        {@link RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration)
         */
        default Builder awsDataCatalogConfiguration(
                Consumer<RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder> awsDataCatalogConfiguration) {
            return awsDataCatalogConfiguration(RedshiftQueryEngineAwsDataCatalogStorageConfiguration.builder()
                    .applyMutation(awsDataCatalogConfiguration).build());
        }

        /**
         * <p>
         * Specifies configurations for storage in Amazon Redshift.
         * </p>
         * 
         * @param redshiftConfiguration
         *        Specifies configurations for storage in Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration);

        /**
         * <p>
         * Specifies configurations for storage in Amazon Redshift.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftQueryEngineRedshiftStorageConfiguration.Builder} avoiding the need to create one manually via
         * {@link RedshiftQueryEngineRedshiftStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftQueryEngineRedshiftStorageConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration)}.
         * 
         * @param redshiftConfiguration
         *        a consumer that will call methods on {@link RedshiftQueryEngineRedshiftStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration)
         */
        default Builder redshiftConfiguration(
                Consumer<RedshiftQueryEngineRedshiftStorageConfiguration.Builder> redshiftConfiguration) {
            return redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration.builder()
                    .applyMutation(redshiftConfiguration).build());
        }

        /**
         * <p>
         * The data storage service to use.
         * </p>
         * 
         * @param type
         *        The data storage service to use.
         * @see RedshiftQueryEngineStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftQueryEngineStorageType
         */
        Builder type(String type);

        /**
         * <p>
         * The data storage service to use.
         * </p>
         * 
         * @param type
         *        The data storage service to use.
         * @see RedshiftQueryEngineStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftQueryEngineStorageType
         */
        Builder type(RedshiftQueryEngineStorageType type);
    }

    static final class BuilderImpl implements Builder {
        private RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration;

        private RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftQueryEngineStorageConfiguration model) {
            awsDataCatalogConfiguration(model.awsDataCatalogConfiguration);
            redshiftConfiguration(model.redshiftConfiguration);
            type(model.type);
        }

        public final RedshiftQueryEngineAwsDataCatalogStorageConfiguration.Builder getAwsDataCatalogConfiguration() {
            return awsDataCatalogConfiguration != null ? awsDataCatalogConfiguration.toBuilder() : null;
        }

        public final void setAwsDataCatalogConfiguration(
                RedshiftQueryEngineAwsDataCatalogStorageConfiguration.BuilderImpl awsDataCatalogConfiguration) {
            this.awsDataCatalogConfiguration = awsDataCatalogConfiguration != null ? awsDataCatalogConfiguration.build() : null;
        }

        @Override
        public final Builder awsDataCatalogConfiguration(
                RedshiftQueryEngineAwsDataCatalogStorageConfiguration awsDataCatalogConfiguration) {
            this.awsDataCatalogConfiguration = awsDataCatalogConfiguration;
            return this;
        }

        public final RedshiftQueryEngineRedshiftStorageConfiguration.Builder getRedshiftConfiguration() {
            return redshiftConfiguration != null ? redshiftConfiguration.toBuilder() : null;
        }

        public final void setRedshiftConfiguration(
                RedshiftQueryEngineRedshiftStorageConfiguration.BuilderImpl redshiftConfiguration) {
            this.redshiftConfiguration = redshiftConfiguration != null ? redshiftConfiguration.build() : null;
        }

        @Override
        public final Builder redshiftConfiguration(RedshiftQueryEngineRedshiftStorageConfiguration redshiftConfiguration) {
            this.redshiftConfiguration = redshiftConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RedshiftQueryEngineStorageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RedshiftQueryEngineStorageConfiguration build() {
            return new RedshiftQueryEngineStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
