/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for authentication to Amazon Redshift Serverless.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftServerlessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftServerlessConfiguration.Builder, RedshiftServerlessConfiguration> {
    private static final SdkField<RedshiftServerlessAuthConfiguration> AUTH_CONFIGURATION_FIELD = SdkField
            .<RedshiftServerlessAuthConfiguration> builder(MarshallingType.SDK_POJO).memberName("authConfiguration")
            .getter(getter(RedshiftServerlessConfiguration::authConfiguration)).setter(setter(Builder::authConfiguration))
            .constructor(RedshiftServerlessAuthConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConfiguration").build()).build();

    private static final SdkField<String> WORKGROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupArn").getter(getter(RedshiftServerlessConfiguration::workgroupArn))
            .setter(setter(Builder::workgroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CONFIGURATION_FIELD,
            WORKGROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RedshiftServerlessAuthConfiguration authConfiguration;

    private final String workgroupArn;

    private RedshiftServerlessConfiguration(BuilderImpl builder) {
        this.authConfiguration = builder.authConfiguration;
        this.workgroupArn = builder.workgroupArn;
    }

    /**
     * <p>
     * Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse.
     * </p>
     * 
     * @return Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse.
     */
    public final RedshiftServerlessAuthConfiguration authConfiguration() {
        return authConfiguration;
    }

    /**
     * <p>
     * The ARN of the Amazon Redshift workgroup.
     * </p>
     * 
     * @return The ARN of the Amazon Redshift workgroup.
     */
    public final String workgroupArn() {
        return workgroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftServerlessConfiguration)) {
            return false;
        }
        RedshiftServerlessConfiguration other = (RedshiftServerlessConfiguration) obj;
        return Objects.equals(authConfiguration(), other.authConfiguration())
                && Objects.equals(workgroupArn(), other.workgroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftServerlessConfiguration").add("AuthConfiguration", authConfiguration())
                .add("WorkgroupArn", workgroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authConfiguration":
            return Optional.ofNullable(clazz.cast(authConfiguration()));
        case "workgroupArn":
            return Optional.ofNullable(clazz.cast(workgroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authConfiguration", AUTH_CONFIGURATION_FIELD);
        map.put("workgroupArn", WORKGROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftServerlessConfiguration, T> g) {
        return obj -> g.apply((RedshiftServerlessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftServerlessConfiguration> {
        /**
         * <p>
         * Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse.
         * </p>
         * 
         * @param authConfiguration
         *        Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfiguration(RedshiftServerlessAuthConfiguration authConfiguration);

        /**
         * <p>
         * Specifies configurations for authentication to an Amazon Redshift provisioned data warehouse.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RedshiftServerlessAuthConfiguration.Builder} avoiding the need to create one manually via
         * {@link RedshiftServerlessAuthConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftServerlessAuthConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authConfiguration(RedshiftServerlessAuthConfiguration)}.
         * 
         * @param authConfiguration
         *        a consumer that will call methods on {@link RedshiftServerlessAuthConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfiguration(RedshiftServerlessAuthConfiguration)
         */
        default Builder authConfiguration(Consumer<RedshiftServerlessAuthConfiguration.Builder> authConfiguration) {
            return authConfiguration(RedshiftServerlessAuthConfiguration.builder().applyMutation(authConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Redshift workgroup.
         * </p>
         * 
         * @param workgroupArn
         *        The ARN of the Amazon Redshift workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupArn(String workgroupArn);
    }

    static final class BuilderImpl implements Builder {
        private RedshiftServerlessAuthConfiguration authConfiguration;

        private String workgroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftServerlessConfiguration model) {
            authConfiguration(model.authConfiguration);
            workgroupArn(model.workgroupArn);
        }

        public final RedshiftServerlessAuthConfiguration.Builder getAuthConfiguration() {
            return authConfiguration != null ? authConfiguration.toBuilder() : null;
        }

        public final void setAuthConfiguration(RedshiftServerlessAuthConfiguration.BuilderImpl authConfiguration) {
            this.authConfiguration = authConfiguration != null ? authConfiguration.build() : null;
        }

        @Override
        public final Builder authConfiguration(RedshiftServerlessAuthConfiguration authConfiguration) {
            this.authConfiguration = authConfiguration;
            return this;
        }

        public final String getWorkgroupArn() {
            return workgroupArn;
        }

        public final void setWorkgroupArn(String workgroupArn) {
            this.workgroupArn = workgroupArn;
        }

        @Override
        public final Builder workgroupArn(String workgroupArn) {
            this.workgroupArn = workgroupArn;
            return this;
        }

        @Override
        public RedshiftServerlessConfiguration build() {
            return new RedshiftServerlessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
