/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the Salesforce content. For example, configuring specific types of Salesforce content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceCrawlerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceCrawlerConfiguration.Builder, SalesforceCrawlerConfiguration> {
    private static final SdkField<CrawlFilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField
            .<CrawlFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("filterConfiguration")
            .getter(getter(SalesforceCrawlerConfiguration::filterConfiguration)).setter(setter(Builder::filterConfiguration))
            .constructor(CrawlFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CrawlFilterConfiguration filterConfiguration;

    private SalesforceCrawlerConfiguration(BuilderImpl builder) {
        this.filterConfiguration = builder.filterConfiguration;
    }

    /**
     * <p>
     * The configuration of filtering the Salesforce content. For example, configuring regular expression patterns to
     * include or exclude certain content.
     * </p>
     * 
     * @return The configuration of filtering the Salesforce content. For example, configuring regular expression
     *         patterns to include or exclude certain content.
     */
    public final CrawlFilterConfiguration filterConfiguration() {
        return filterConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceCrawlerConfiguration)) {
            return false;
        }
        SalesforceCrawlerConfiguration other = (SalesforceCrawlerConfiguration) obj;
        return Objects.equals(filterConfiguration(), other.filterConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceCrawlerConfiguration").add("FilterConfiguration", filterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterConfiguration":
            return Optional.ofNullable(clazz.cast(filterConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filterConfiguration", FILTER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SalesforceCrawlerConfiguration, T> g) {
        return obj -> g.apply((SalesforceCrawlerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceCrawlerConfiguration> {
        /**
         * <p>
         * The configuration of filtering the Salesforce content. For example, configuring regular expression patterns
         * to include or exclude certain content.
         * </p>
         * 
         * @param filterConfiguration
         *        The configuration of filtering the Salesforce content. For example, configuring regular expression
         *        patterns to include or exclude certain content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(CrawlFilterConfiguration filterConfiguration);

        /**
         * <p>
         * The configuration of filtering the Salesforce content. For example, configuring regular expression patterns
         * to include or exclude certain content.
         * </p>
         * This is a convenience method that creates an instance of the {@link CrawlFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link CrawlFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrawlFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #filterConfiguration(CrawlFilterConfiguration)}.
         * 
         * @param filterConfiguration
         *        a consumer that will call methods on {@link CrawlFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConfiguration(CrawlFilterConfiguration)
         */
        default Builder filterConfiguration(Consumer<CrawlFilterConfiguration.Builder> filterConfiguration) {
            return filterConfiguration(CrawlFilterConfiguration.builder().applyMutation(filterConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CrawlFilterConfiguration filterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceCrawlerConfiguration model) {
            filterConfiguration(model.filterConfiguration);
        }

        public final CrawlFilterConfiguration.Builder getFilterConfiguration() {
            return filterConfiguration != null ? filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(CrawlFilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(CrawlFilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        @Override
        public SalesforceCrawlerConfiguration build() {
            return new SalesforceCrawlerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
