/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for SESSION_SUMMARY memory type enabled for the agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionSummaryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionSummaryConfiguration.Builder, SessionSummaryConfiguration> {
    private static final SdkField<Integer> MAX_RECENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRecentSessions").getter(getter(SessionSummaryConfiguration::maxRecentSessions))
            .setter(setter(Builder::maxRecentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRecentSessions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RECENT_SESSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxRecentSessions;

    private SessionSummaryConfiguration(BuilderImpl builder) {
        this.maxRecentSessions = builder.maxRecentSessions;
    }

    /**
     * <p>
     * Maximum number of recent session summaries to include in the agent's prompt context.
     * </p>
     * 
     * @return Maximum number of recent session summaries to include in the agent's prompt context.
     */
    public final Integer maxRecentSessions() {
        return maxRecentSessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxRecentSessions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionSummaryConfiguration)) {
            return false;
        }
        SessionSummaryConfiguration other = (SessionSummaryConfiguration) obj;
        return Objects.equals(maxRecentSessions(), other.maxRecentSessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionSummaryConfiguration").add("MaxRecentSessions", maxRecentSessions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxRecentSessions":
            return Optional.ofNullable(clazz.cast(maxRecentSessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxRecentSessions", MAX_RECENT_SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionSummaryConfiguration, T> g) {
        return obj -> g.apply((SessionSummaryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionSummaryConfiguration> {
        /**
         * <p>
         * Maximum number of recent session summaries to include in the agent's prompt context.
         * </p>
         * 
         * @param maxRecentSessions
         *        Maximum number of recent session summaries to include in the agent's prompt context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecentSessions(Integer maxRecentSessions);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxRecentSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionSummaryConfiguration model) {
            maxRecentSessions(model.maxRecentSessions);
        }

        public final Integer getMaxRecentSessions() {
            return maxRecentSessions;
        }

        public final void setMaxRecentSessions(Integer maxRecentSessions) {
            this.maxRecentSessions = maxRecentSessions;
        }

        @Override
        public final Builder maxRecentSessions(Integer maxRecentSessions) {
            this.maxRecentSessions = maxRecentSessions;
            return this;
        }

        @Override
        public SessionSummaryConfiguration build() {
            return new SessionSummaryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
