/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configurations for the storage location of the images extracted from multimodal documents in your data
 * source. These images can be retrieved and returned to the end user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupplementalDataStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SupplementalDataStorageConfiguration.Builder, SupplementalDataStorageConfiguration> {
    private static final SdkField<List<SupplementalDataStorageLocation>> STORAGE_LOCATIONS_FIELD = SdkField
            .<List<SupplementalDataStorageLocation>> builder(MarshallingType.LIST)
            .memberName("storageLocations")
            .getter(getter(SupplementalDataStorageConfiguration::storageLocations))
            .setter(setter(Builder::storageLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupplementalDataStorageLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupplementalDataStorageLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_LOCATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SupplementalDataStorageLocation> storageLocations;

    private SupplementalDataStorageConfiguration(BuilderImpl builder) {
        this.storageLocations = builder.storageLocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageLocations() {
        return storageLocations != null && !(storageLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects specifying storage locations for images extracted from multimodal documents in your data
     * source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageLocations} method.
     * </p>
     * 
     * @return A list of objects specifying storage locations for images extracted from multimodal documents in your
     *         data source.
     */
    public final List<SupplementalDataStorageLocation> storageLocations() {
        return storageLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageLocations() ? storageLocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementalDataStorageConfiguration)) {
            return false;
        }
        SupplementalDataStorageConfiguration other = (SupplementalDataStorageConfiguration) obj;
        return hasStorageLocations() == other.hasStorageLocations()
                && Objects.equals(storageLocations(), other.storageLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupplementalDataStorageConfiguration")
                .add("StorageLocations", hasStorageLocations() ? storageLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageLocations":
            return Optional.ofNullable(clazz.cast(storageLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageLocations", STORAGE_LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupplementalDataStorageConfiguration, T> g) {
        return obj -> g.apply((SupplementalDataStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupplementalDataStorageConfiguration> {
        /**
         * <p>
         * A list of objects specifying storage locations for images extracted from multimodal documents in your data
         * source.
         * </p>
         * 
         * @param storageLocations
         *        A list of objects specifying storage locations for images extracted from multimodal documents in your
         *        data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocations(Collection<SupplementalDataStorageLocation> storageLocations);

        /**
         * <p>
         * A list of objects specifying storage locations for images extracted from multimodal documents in your data
         * source.
         * </p>
         * 
         * @param storageLocations
         *        A list of objects specifying storage locations for images extracted from multimodal documents in your
         *        data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocations(SupplementalDataStorageLocation... storageLocations);

        /**
         * <p>
         * A list of objects specifying storage locations for images extracted from multimodal documents in your data
         * source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.SupplementalDataStorageLocation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.SupplementalDataStorageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.SupplementalDataStorageLocation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #storageLocations(List<SupplementalDataStorageLocation>)}.
         * 
         * @param storageLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.SupplementalDataStorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocations(java.util.Collection<SupplementalDataStorageLocation>)
         */
        Builder storageLocations(Consumer<SupplementalDataStorageLocation.Builder>... storageLocations);
    }

    static final class BuilderImpl implements Builder {
        private List<SupplementalDataStorageLocation> storageLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementalDataStorageConfiguration model) {
            storageLocations(model.storageLocations);
        }

        public final List<SupplementalDataStorageLocation.Builder> getStorageLocations() {
            List<SupplementalDataStorageLocation.Builder> result = SupplementalDataStorageLocationsCopier
                    .copyToBuilder(this.storageLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageLocations(Collection<SupplementalDataStorageLocation.BuilderImpl> storageLocations) {
            this.storageLocations = SupplementalDataStorageLocationsCopier.copyFromBuilder(storageLocations);
        }

        @Override
        public final Builder storageLocations(Collection<SupplementalDataStorageLocation> storageLocations) {
            this.storageLocations = SupplementalDataStorageLocationsCopier.copy(storageLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageLocations(SupplementalDataStorageLocation... storageLocations) {
            storageLocations(Arrays.asList(storageLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageLocations(Consumer<SupplementalDataStorageLocation.Builder>... storageLocations) {
            storageLocations(Stream.of(storageLocations)
                    .map(c -> SupplementalDataStorageLocation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SupplementalDataStorageConfiguration build() {
            return new SupplementalDataStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
