/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines which tools the model should request when invoked. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Use a tool to complete an Amazon Bedrock
 * model response</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolChoice implements SdkPojo, Serializable, ToCopyableBuilder<ToolChoice.Builder, ToolChoice> {
    private static final SdkField<AnyToolChoice> ANY_FIELD = SdkField.<AnyToolChoice> builder(MarshallingType.SDK_POJO)
            .memberName("any").getter(getter(ToolChoice::any)).setter(setter(Builder::any)).constructor(AnyToolChoice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("any").build()).build();

    private static final SdkField<AutoToolChoice> AUTO_FIELD = SdkField.<AutoToolChoice> builder(MarshallingType.SDK_POJO)
            .memberName("auto").getter(getter(ToolChoice::auto)).setter(setter(Builder::auto))
            .constructor(AutoToolChoice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auto").build()).build();

    private static final SdkField<SpecificToolChoice> TOOL_FIELD = SdkField
            .<SpecificToolChoice> builder(MarshallingType.SDK_POJO).memberName("tool").getter(getter(ToolChoice::tool))
            .setter(setter(Builder::tool)).constructor(SpecificToolChoice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANY_FIELD, AUTO_FIELD,
            TOOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnyToolChoice any;

    private final AutoToolChoice auto;

    private final SpecificToolChoice tool;

    private final Type type;

    private ToolChoice(BuilderImpl builder) {
        this.any = builder.any;
        this.auto = builder.auto;
        this.tool = builder.tool;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines tools, at least one of which must be requested by the model. No text is generated but the results of tool
     * use are sent back to the model to help generate a response.
     * </p>
     * 
     * @return Defines tools, at least one of which must be requested by the model. No text is generated but the results
     *         of tool use are sent back to the model to help generate a response.
     */
    public final AnyToolChoice any() {
        return any;
    }

    /**
     * <p>
     * Defines tools. The model automatically decides whether to call a tool or to generate text instead.
     * </p>
     * 
     * @return Defines tools. The model automatically decides whether to call a tool or to generate text instead.
     */
    public final AutoToolChoice auto() {
        return auto;
    }

    /**
     * <p>
     * Defines a specific tool that the model must request. No text is generated but the results of tool use are sent
     * back to the model to help generate a response.
     * </p>
     * 
     * @return Defines a specific tool that the model must request. No text is generated but the results of tool use are
     *         sent back to the model to help generate a response.
     */
    public final SpecificToolChoice tool() {
        return tool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(any());
        hashCode = 31 * hashCode + Objects.hashCode(auto());
        hashCode = 31 * hashCode + Objects.hashCode(tool());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolChoice)) {
            return false;
        }
        ToolChoice other = (ToolChoice) obj;
        return Objects.equals(any(), other.any()) && Objects.equals(auto(), other.auto()) && Objects.equals(tool(), other.tool());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolChoice").add("Any", any()).add("Auto", auto()).add("Tool", tool()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "any":
            return Optional.ofNullable(clazz.cast(any()));
        case "auto":
            return Optional.ofNullable(clazz.cast(auto()));
        case "tool":
            return Optional.ofNullable(clazz.cast(tool()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #any()} initialized to the given value.
     *
     * <p>
     * Defines tools, at least one of which must be requested by the model. No text is generated but the results of tool
     * use are sent back to the model to help generate a response.
     * </p>
     * 
     * @param any
     *        Defines tools, at least one of which must be requested by the model. No text is generated but the results
     *        of tool use are sent back to the model to help generate a response.
     */
    public static ToolChoice fromAny(AnyToolChoice any) {
        return builder().any(any).build();
    }

    /**
     * Create an instance of this class with {@link #any()} initialized to the given value.
     *
     * <p>
     * Defines tools, at least one of which must be requested by the model. No text is generated but the results of tool
     * use are sent back to the model to help generate a response.
     * </p>
     * 
     * @param any
     *        Defines tools, at least one of which must be requested by the model. No text is generated but the results
     *        of tool use are sent back to the model to help generate a response.
     */
    public static ToolChoice fromAny(Consumer<AnyToolChoice.Builder> any) {
        AnyToolChoice.Builder builder = AnyToolChoice.builder();
        any.accept(builder);
        return fromAny(builder.build());
    }

    /**
     * Create an instance of this class with {@link #auto()} initialized to the given value.
     *
     * <p>
     * Defines tools. The model automatically decides whether to call a tool or to generate text instead.
     * </p>
     * 
     * @param auto
     *        Defines tools. The model automatically decides whether to call a tool or to generate text instead.
     */
    public static ToolChoice fromAuto(AutoToolChoice auto) {
        return builder().auto(auto).build();
    }

    /**
     * Create an instance of this class with {@link #auto()} initialized to the given value.
     *
     * <p>
     * Defines tools. The model automatically decides whether to call a tool or to generate text instead.
     * </p>
     * 
     * @param auto
     *        Defines tools. The model automatically decides whether to call a tool or to generate text instead.
     */
    public static ToolChoice fromAuto(Consumer<AutoToolChoice.Builder> auto) {
        AutoToolChoice.Builder builder = AutoToolChoice.builder();
        auto.accept(builder);
        return fromAuto(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tool()} initialized to the given value.
     *
     * <p>
     * Defines a specific tool that the model must request. No text is generated but the results of tool use are sent
     * back to the model to help generate a response.
     * </p>
     * 
     * @param tool
     *        Defines a specific tool that the model must request. No text is generated but the results of tool use are
     *        sent back to the model to help generate a response.
     */
    public static ToolChoice fromTool(SpecificToolChoice tool) {
        return builder().tool(tool).build();
    }

    /**
     * Create an instance of this class with {@link #tool()} initialized to the given value.
     *
     * <p>
     * Defines a specific tool that the model must request. No text is generated but the results of tool use are sent
     * back to the model to help generate a response.
     * </p>
     * 
     * @param tool
     *        Defines a specific tool that the model must request. No text is generated but the results of tool use are
     *        sent back to the model to help generate a response.
     */
    public static ToolChoice fromTool(Consumer<SpecificToolChoice.Builder> tool) {
        SpecificToolChoice.Builder builder = SpecificToolChoice.builder();
        tool.accept(builder);
        return fromTool(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("any", ANY_FIELD);
        map.put("auto", AUTO_FIELD);
        map.put("tool", TOOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolChoice, T> g) {
        return obj -> g.apply((ToolChoice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolChoice> {
        /**
         * <p>
         * Defines tools, at least one of which must be requested by the model. No text is generated but the results of
         * tool use are sent back to the model to help generate a response.
         * </p>
         * 
         * @param any
         *        Defines tools, at least one of which must be requested by the model. No text is generated but the
         *        results of tool use are sent back to the model to help generate a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder any(AnyToolChoice any);

        /**
         * <p>
         * Defines tools, at least one of which must be requested by the model. No text is generated but the results of
         * tool use are sent back to the model to help generate a response.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnyToolChoice.Builder} avoiding the need
         * to create one manually via {@link AnyToolChoice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnyToolChoice.Builder#build()} is called immediately and its
         * result is passed to {@link #any(AnyToolChoice)}.
         * 
         * @param any
         *        a consumer that will call methods on {@link AnyToolChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #any(AnyToolChoice)
         */
        default Builder any(Consumer<AnyToolChoice.Builder> any) {
            return any(AnyToolChoice.builder().applyMutation(any).build());
        }

        /**
         * <p>
         * Defines tools. The model automatically decides whether to call a tool or to generate text instead.
         * </p>
         * 
         * @param auto
         *        Defines tools. The model automatically decides whether to call a tool or to generate text instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auto(AutoToolChoice auto);

        /**
         * <p>
         * Defines tools. The model automatically decides whether to call a tool or to generate text instead.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoToolChoice.Builder} avoiding the need
         * to create one manually via {@link AutoToolChoice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoToolChoice.Builder#build()} is called immediately and its
         * result is passed to {@link #auto(AutoToolChoice)}.
         * 
         * @param auto
         *        a consumer that will call methods on {@link AutoToolChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auto(AutoToolChoice)
         */
        default Builder auto(Consumer<AutoToolChoice.Builder> auto) {
            return auto(AutoToolChoice.builder().applyMutation(auto).build());
        }

        /**
         * <p>
         * Defines a specific tool that the model must request. No text is generated but the results of tool use are
         * sent back to the model to help generate a response.
         * </p>
         * 
         * @param tool
         *        Defines a specific tool that the model must request. No text is generated but the results of tool use
         *        are sent back to the model to help generate a response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tool(SpecificToolChoice tool);

        /**
         * <p>
         * Defines a specific tool that the model must request. No text is generated but the results of tool use are
         * sent back to the model to help generate a response.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpecificToolChoice.Builder} avoiding the
         * need to create one manually via {@link SpecificToolChoice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpecificToolChoice.Builder#build()} is called immediately and its
         * result is passed to {@link #tool(SpecificToolChoice)}.
         * 
         * @param tool
         *        a consumer that will call methods on {@link SpecificToolChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tool(SpecificToolChoice)
         */
        default Builder tool(Consumer<SpecificToolChoice.Builder> tool) {
            return tool(SpecificToolChoice.builder().applyMutation(tool).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnyToolChoice any;

        private AutoToolChoice auto;

        private SpecificToolChoice tool;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolChoice model) {
            any(model.any);
            auto(model.auto);
            tool(model.tool);
        }

        public final AnyToolChoice.Builder getAny() {
            return any != null ? any.toBuilder() : null;
        }

        public final void setAny(AnyToolChoice.BuilderImpl any) {
            Object oldValue = this.any;
            this.any = any != null ? any.build() : null;
            handleUnionValueChange(Type.ANY, oldValue, this.any);
        }

        @Override
        public final Builder any(AnyToolChoice any) {
            Object oldValue = this.any;
            this.any = any;
            handleUnionValueChange(Type.ANY, oldValue, this.any);
            return this;
        }

        public final AutoToolChoice.Builder getAuto() {
            return auto != null ? auto.toBuilder() : null;
        }

        public final void setAuto(AutoToolChoice.BuilderImpl auto) {
            Object oldValue = this.auto;
            this.auto = auto != null ? auto.build() : null;
            handleUnionValueChange(Type.AUTO, oldValue, this.auto);
        }

        @Override
        public final Builder auto(AutoToolChoice auto) {
            Object oldValue = this.auto;
            this.auto = auto;
            handleUnionValueChange(Type.AUTO, oldValue, this.auto);
            return this;
        }

        public final SpecificToolChoice.Builder getTool() {
            return tool != null ? tool.toBuilder() : null;
        }

        public final void setTool(SpecificToolChoice.BuilderImpl tool) {
            Object oldValue = this.tool;
            this.tool = tool != null ? tool.build() : null;
            handleUnionValueChange(Type.TOOL, oldValue, this.tool);
        }

        @Override
        public final Builder tool(SpecificToolChoice tool) {
            Object oldValue = this.tool;
            this.tool = tool;
            handleUnionValueChange(Type.TOOL, oldValue, this.tool);
            return this;
        }

        @Override
        public ToolChoice build() {
            return new ToolChoice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ToolChoice#type()
     */
    public enum Type {
        ANY,

        AUTO,

        TOOL,

        UNKNOWN_TO_SDK_VERSION
    }
}
